/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.plugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.plugin.PluginLoader;
import io.digdag.core.plugin.PluginSet;
import io.digdag.core.plugin.Spec;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class DynamicPluginLoader<R> {
    private final PluginLoader loader;
    private final Injector injector;
    private final Function<PluginSet.WithInjector, R> cacheBuilder;
    private final Cache<Spec, R> cache;

    public static <R> DynamicPluginLoader<R> build(PluginLoader loader, Module restrictInjectModule, Function<PluginSet.WithInjector, R> cacheBuilder, int maxCacheSize) {
        return new DynamicPluginLoader<R>(loader, restrictInjectModule, cacheBuilder, maxCacheSize);
    }

    private DynamicPluginLoader(PluginLoader loader, Module restrictInjectModule, Function<PluginSet.WithInjector, R> cacheBuilder, int maxCacheSize) {
        this.loader = loader;
        this.injector = DynamicPluginLoader.buildRestrictedInjector(restrictInjectModule);
        this.cacheBuilder = cacheBuilder;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    }

    public R load(Spec spec) {
        try {
            return (R)this.cache.get((Object)spec, () -> this.loadCache(spec));
        }
        catch (UncheckedExecutionException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex.getCause());
        }
        catch (ExecutionException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex.getCause());
        }
    }

    private R loadCache(Spec spec) {
        PluginSet plugins = this.loader.load(spec);
        return this.cacheBuilder.apply(plugins.withInjector(this.injector));
    }

    private static Injector buildRestrictedInjector(Module module) {
        return Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)ImmutableList.of((Object)module, binder -> binder.disableCircularProxies()));
    }
}

