/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.notification;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.inject.Inject;
import io.digdag.client.api.JacksonTimeModule;
import io.digdag.client.config.Config;
import io.digdag.spi.Notification;
import io.digdag.spi.NotificationException;
import io.digdag.spi.NotificationSender;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.core.Headers;

public class HttpNotificationSender
implements NotificationSender {
    private static final String NOTIFICATION_HTTP_METHOD = "notification.http.method";
    private static final String NOTIFICATION_HTTP_METHOD_DEFAULT = "POST";
    private static final String NOTIFICATION_HTTP_URL = "notification.http.url";
    private static final String NOTIFICATION_HTTP_HEADERS_PREFIX = "notification.http.headers.";
    private final Client client = new ResteasyClientBuilder().register((Object)new JacksonJsonProvider(HttpNotificationSender.objectMapper())).connectionPoolSize(32).build();
    private final WebTarget target;
    private final Headers<Object> headers;
    private final String url;
    private final String method;

    @Inject
    public HttpNotificationSender(Config systemConfig) {
        this.url = (String)systemConfig.get(NOTIFICATION_HTTP_URL, String.class);
        this.target = this.client.target(this.url);
        this.headers = this.headers(systemConfig);
        this.method = (String)systemConfig.get(NOTIFICATION_HTTP_METHOD, String.class, (Object)NOTIFICATION_HTTP_METHOD_DEFAULT);
    }

    private Headers<Object> headers(Config systemConfig) {
        Headers headers = new Headers();
        systemConfig.getKeys().stream().filter(k -> k.startsWith(NOTIFICATION_HTTP_HEADERS_PREFIX)).forEach(k -> {
            String name = k.substring(NOTIFICATION_HTTP_HEADERS_PREFIX.length());
            String value = (String)systemConfig.get(k, String.class);
            headers.add((Object)name, (Object)value);
        });
        return headers;
    }

    private static ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new JacksonTimeModule());
        return mapper;
    }

    public void sendNotification(Notification notification) throws NotificationException {
        Response response = this.target.request().headers(this.headers).method(this.method, Entity.entity((Object)notification, (String)"application/json"));
        response.close();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new NotificationException("Failed to send HTTP notification: status=" + response.getStatusInfo());
        }
    }
}

