/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.log.AbstractFileLogServer;
import io.digdag.spi.DirectDownloadHandle;
import io.digdag.spi.DirectUploadHandle;
import io.digdag.spi.Storage;
import io.digdag.spi.StorageFileNotFoundException;
import io.digdag.spi.StorageObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StorageFileLogServer
extends AbstractFileLogServer {
    private final Storage storage;
    private final String logPath;
    private final boolean directDownloadEnabled;

    public StorageFileLogServer(Storage storage, String logPath, boolean directDownloadEnabled) {
        this.storage = storage;
        this.logPath = logPath;
        this.directDownloadEnabled = directDownloadEnabled;
    }

    private String getPrefixDir(String dateDir, String attemptDir) {
        return this.logPath + dateDir + "/" + attemptDir + "/";
    }

    @Override
    public Optional<DirectUploadHandle> getDirectUploadHandle(String dateDir, String attemptDir, String fileName) {
        return this.storage.getDirectUploadHandle(this.getPrefixDir(dateDir, attemptDir) + fileName);
    }

    @Override
    protected void putFile(String dateDir, String attemptDir, String fileName, byte[] gzData) {
        String path = this.getPrefixDir(dateDir, attemptDir) + fileName;
        try {
            this.storage.put(path, (long)gzData.length, () -> new ByteArrayInputStream(gzData));
        }
        catch (Throwable ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getFile(String dateDir, String attemptDir, String fileName) throws StorageFileNotFoundException {
        String path = this.getPrefixDir(dateDir, attemptDir) + fileName;
        try {
            StorageObject obj = this.storage.open(path);
            try (InputStream in = obj.getContentInputStream();){
                if (obj.getContentLength() > 0x20000000L) {
                    throw new RuntimeException("Non-direct downloding log files larger than 512MB is not supported");
                }
                byte[] data = new byte[(int)obj.getContentLength()];
                ByteStreams.readFully((InputStream)in, (byte[])data);
                byte[] byArray = data;
                return byArray;
            }
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    @Override
    protected void listFiles(String dateDir, String attemptDir, boolean enableDirectDownload, AbstractFileLogServer.FileMetadataConsumer consumer) {
        String dir = this.getPrefixDir(dateDir, attemptDir);
        this.storage.list(dir, chunk -> chunk.forEach(meta -> {
            String key = meta.getKey();
            String fileName = key.substring(dir.length());
            consumer.accept(fileName, meta.getContentLength(), this.directDownloadEnabled && enableDirectDownload ? (DirectDownloadHandle)this.storage.getDirectDownloadHandle(key).orNull() : null);
        }));
    }
}

