/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.core.TempFileManager;
import io.digdag.core.agent.AgentId;
import io.digdag.core.log.BufferedRemoteTaskLogger;
import io.digdag.core.log.LocalFileLogServerFactory;
import io.digdag.core.log.NullLogServerFactory;
import io.digdag.core.log.NullTaskLogger;
import io.digdag.core.log.StorageFileLogServer;
import io.digdag.core.log.TaskLogger;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.core.storage.StorageManager;
import io.digdag.spi.LogFilePrefix;
import io.digdag.spi.LogServer;
import io.digdag.spi.LogServerFactory;
import io.digdag.spi.Storage;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Set;

public class LogServerManager {
    private static final DateTimeFormatter ISO8601_SHORT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssX", Locale.ENGLISH).withZone(ZoneOffset.UTC);
    private final LogServer logServer;
    private final TempFileManager tempFiles;

    @Inject
    public LogServerManager(Set<LogServerFactory> factories, Config systemConfig, TempFileManager tempFiles, StorageManager storageManager) {
        String type = (String)systemConfig.get("log-server.type", String.class, (Object)"null");
        LogServerFactory factory = LogServerManager.findLogServer(factories, type);
        this.logServer = factory == null ? this.newStorageLogServer(storageManager, type, systemConfig) : factory.getLogServer();
        this.tempFiles = tempFiles;
    }

    private static LogServerFactory findLogServer(Set<LogServerFactory> factories, String type) {
        for (LogServerFactory factory : factories) {
            if (!type.equals(factory.getType())) continue;
            return factory;
        }
        return null;
    }

    public LogServer newStorageLogServer(StorageManager storageManager, String type, Config systemConfig) {
        Storage storage = storageManager.create(type, systemConfig, "log-server.");
        String logPath = (String)systemConfig.get("log-server." + type + ".path", String.class, (Object)"");
        boolean directDownload = (Boolean)systemConfig.get("log-server." + type + ".direct_download", Boolean.TYPE, (Object)false);
        if (logPath.startsWith("/")) {
            logPath = logPath.substring(1);
        }
        if (!logPath.endsWith("/") && !logPath.isEmpty()) {
            logPath = logPath + "/";
        }
        return new StorageFileLogServer(storage, logPath, directDownload);
    }

    public LogServer getLogServer() {
        return this.logServer;
    }

    public TaskLogger newInProcessTaskLogger(AgentId agentId, LogFilePrefix prefix, String taskName) {
        if (this.logServer instanceof NullLogServerFactory.NullLogServer) {
            return new NullTaskLogger();
        }
        if (this.logServer instanceof LocalFileLogServerFactory.LocalFileLogServer) {
            return ((LocalFileLogServerFactory.LocalFileLogServer)this.logServer).newDirectTaskLogger(prefix, taskName);
        }
        String tempFilePrefix = prefix.getProjectId() + "_" + prefix.getWorkflowName() + "_" + ISO8601_SHORT.format(prefix.getSessionTime());
        return new BufferedRemoteTaskLogger(this.tempFiles, tempFilePrefix, (firstLogTime, gzData) -> this.logServer.putFile(prefix, taskName, firstLogTime, agentId.toString(), gzData));
    }

    public static LogFilePrefix logFilePrefixFromSessionAttempt(StoredSessionAttemptWithSession attempt) {
        return LogFilePrefix.builder().siteId(attempt.getSiteId()).projectId(attempt.getSession().getProjectId()).workflowName(attempt.getSession().getWorkflowName()).sessionTime(attempt.getSession().getSessionTime()).timeZone(attempt.getTimeZone()).retryAttemptName(attempt.getRetryAttemptName()).createdAt(attempt.getCreatedAt()).build();
    }
}

