/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.database.DatabaseProjectStoreManager;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableWorkflowConfig
extends DatabaseProjectStoreManager.WorkflowConfig {
    private final int id;
    private final String configText;
    private final String timeZone;

    private ImmutableWorkflowConfig(int id, String configText, String timeZone) {
        this.id = id;
        this.configText = configText;
        this.timeZone = timeZone;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getConfigText() {
        return this.configText;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    public final ImmutableWorkflowConfig withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableWorkflowConfig(value, this.configText, this.timeZone);
    }

    public final ImmutableWorkflowConfig withConfigText(String value) {
        if (this.configText.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"configText");
        return new ImmutableWorkflowConfig(this.id, newValue, this.timeZone);
    }

    public final ImmutableWorkflowConfig withTimeZone(String value) {
        if (this.timeZone.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return new ImmutableWorkflowConfig(this.id, this.configText, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowConfig && this.equalTo((ImmutableWorkflowConfig)another);
    }

    private boolean equalTo(ImmutableWorkflowConfig another) {
        return this.id == another.id && this.configText.equals(another.configText) && this.timeZone.equals(another.timeZone);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id;
        h = h * 17 + this.configText.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowConfig").omitNullValues().add("id", this.id).add("configText", (Object)this.configText).add("timeZone", (Object)this.timeZone).toString();
    }

    public static ImmutableWorkflowConfig copyOf(DatabaseProjectStoreManager.WorkflowConfig instance) {
        if (instance instanceof ImmutableWorkflowConfig) {
            return (ImmutableWorkflowConfig)instance;
        }
        return ImmutableWorkflowConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CONFIG_TEXT = 2L;
        private static final long INIT_BIT_TIME_ZONE = 4L;
        private long initBits = 7L;
        private int id;
        @Nullable
        private String configText;
        @Nullable
        private String timeZone;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DatabaseProjectStoreManager.WorkflowConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.configText(instance.getConfigText());
            this.timeZone(instance.getTimeZone());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configText(String configText) {
            this.configText = (String)Preconditions.checkNotNull((Object)configText, (Object)"configText");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeZone(String timeZone) {
            this.timeZone = (String)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableWorkflowConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWorkflowConfig(this.id, this.configText, this.timeZone);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("configText");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("timeZone");
            }
            return "Cannot build WorkflowConfig, some of required attributes are not set " + attributes;
        }
    }
}

