/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.database.RemoteDatabaseConfig;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableRemoteDatabaseConfig
implements RemoteDatabaseConfig {
    private final String user;
    private final String password;
    private final String host;
    private final Optional<Integer> port;
    private final int loginTimeout;
    private final int socketTimeout;
    private final boolean ssl;
    private final String sslfactory;
    private final Optional<String> sslmode;
    private final Optional<String> sslcert;
    private final Optional<String> sslkey;
    private final Optional<String> sslrootcert;
    private final String database;

    private ImmutableRemoteDatabaseConfig(String user, String password, String host, Optional<Integer> port, int loginTimeout, int socketTimeout, boolean ssl, String sslfactory, Optional<String> sslmode, Optional<String> sslcert, Optional<String> sslkey, Optional<String> sslrootcert, String database) {
        this.user = user;
        this.password = password;
        this.host = host;
        this.port = port;
        this.loginTimeout = loginTimeout;
        this.socketTimeout = socketTimeout;
        this.ssl = ssl;
        this.sslfactory = sslfactory;
        this.sslmode = sslmode;
        this.sslcert = sslcert;
        this.sslkey = sslkey;
        this.sslrootcert = sslrootcert;
        this.database = database;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Optional<Integer> getPort() {
        return this.port;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public boolean getSsl() {
        return this.ssl;
    }

    @Override
    public String getSslfactory() {
        return this.sslfactory;
    }

    @Override
    public Optional<String> getSslmode() {
        return this.sslmode;
    }

    @Override
    public Optional<String> getSslcert() {
        return this.sslcert;
    }

    @Override
    public Optional<String> getSslkey() {
        return this.sslkey;
    }

    @Override
    public Optional<String> getSslrootcert() {
        return this.sslrootcert;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public final ImmutableRemoteDatabaseConfig withUser(String value) {
        if (this.user.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"user");
        return new ImmutableRemoteDatabaseConfig(newValue, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withPassword(String value) {
        if (this.password.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"password");
        return new ImmutableRemoteDatabaseConfig(this.user, newValue, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withHost(String value) {
        if (this.host.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"host");
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, newValue, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withPort(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.port.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, (Optional<Integer>)newValue, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withPort(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"port");
        if (this.port.equals((Object)value)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, (Optional<Integer>)value, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withLoginTimeout(int value) {
        if (this.loginTimeout == value) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, value, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSocketTimeout(int value) {
        if (this.socketTimeout == value) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, value, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSsl(boolean value) {
        if (this.ssl == value) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, value, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslfactory(String value) {
        if (this.sslfactory.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"sslfactory");
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, newValue, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslmode(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.sslmode.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, (Optional<String>)newValue, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslmode(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"sslmode");
        if (this.sslmode.equals((Object)value)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, (Optional<String>)value, this.sslcert, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslcert(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.sslcert.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, (Optional<String>)newValue, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslcert(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"sslcert");
        if (this.sslcert.equals((Object)value)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, (Optional<String>)value, this.sslkey, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslkey(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.sslkey.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, (Optional<String>)newValue, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslkey(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"sslkey");
        if (this.sslkey.equals((Object)value)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, (Optional<String>)value, this.sslrootcert, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslrootcert(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.sslrootcert.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, (Optional<String>)newValue, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withSslrootcert(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"sslrootcert");
        if (this.sslrootcert.equals((Object)value)) {
            return this;
        }
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, (Optional<String>)value, this.database);
    }

    public final ImmutableRemoteDatabaseConfig withDatabase(String value) {
        if (this.database.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"database");
        return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRemoteDatabaseConfig && this.equalTo((ImmutableRemoteDatabaseConfig)another);
    }

    private boolean equalTo(ImmutableRemoteDatabaseConfig another) {
        return this.user.equals(another.user) && this.password.equals(another.password) && this.host.equals(another.host) && this.port.equals(another.port) && this.loginTimeout == another.loginTimeout && this.socketTimeout == another.socketTimeout && this.ssl == another.ssl && this.sslfactory.equals(another.sslfactory) && this.sslmode.equals(another.sslmode) && this.sslcert.equals(another.sslcert) && this.sslkey.equals(another.sslkey) && this.sslrootcert.equals(another.sslrootcert) && this.database.equals(another.database);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.password.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + this.port.hashCode();
        h = h * 17 + this.loginTimeout;
        h = h * 17 + this.socketTimeout;
        h = h * 17 + Booleans.hashCode((boolean)this.ssl);
        h = h * 17 + this.sslfactory.hashCode();
        h = h * 17 + this.sslmode.hashCode();
        h = h * 17 + this.sslcert.hashCode();
        h = h * 17 + this.sslkey.hashCode();
        h = h * 17 + this.sslrootcert.hashCode();
        h = h * 17 + this.database.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RemoteDatabaseConfig").omitNullValues().add("user", (Object)this.user).add("password", (Object)this.password).add("host", (Object)this.host).add("port", this.port.orNull()).add("loginTimeout", this.loginTimeout).add("socketTimeout", this.socketTimeout).add("ssl", this.ssl).add("sslfactory", (Object)this.sslfactory).add("sslmode", this.sslmode.orNull()).add("sslcert", this.sslcert.orNull()).add("sslkey", this.sslkey.orNull()).add("sslrootcert", this.sslrootcert.orNull()).add("database", (Object)this.database).toString();
    }

    public static ImmutableRemoteDatabaseConfig copyOf(RemoteDatabaseConfig instance) {
        if (instance instanceof ImmutableRemoteDatabaseConfig) {
            return (ImmutableRemoteDatabaseConfig)instance;
        }
        return ImmutableRemoteDatabaseConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private static final long INIT_BIT_HOST = 4L;
        private static final long INIT_BIT_LOGIN_TIMEOUT = 8L;
        private static final long INIT_BIT_SOCKET_TIMEOUT = 16L;
        private static final long INIT_BIT_SSL = 32L;
        private static final long INIT_BIT_SSLFACTORY = 64L;
        private static final long INIT_BIT_DATABASE = 128L;
        private long initBits = 255L;
        @Nullable
        private String user;
        @Nullable
        private String password;
        @Nullable
        private String host;
        private Optional<Integer> port = Optional.absent();
        private int loginTimeout;
        private int socketTimeout;
        private boolean ssl;
        @Nullable
        private String sslfactory;
        private Optional<String> sslmode = Optional.absent();
        private Optional<String> sslcert = Optional.absent();
        private Optional<String> sslkey = Optional.absent();
        private Optional<String> sslrootcert = Optional.absent();
        @Nullable
        private String database;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RemoteDatabaseConfig instance) {
            Optional<String> sslrootcertOptional;
            Optional<String> sslkeyOptional;
            Optional<String> sslcertOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.user(instance.getUser());
            this.password(instance.getPassword());
            this.host(instance.getHost());
            Optional<Integer> portOptional = instance.getPort();
            if (portOptional.isPresent()) {
                this.port(portOptional);
            }
            this.loginTimeout(instance.getLoginTimeout());
            this.socketTimeout(instance.getSocketTimeout());
            this.ssl(instance.getSsl());
            this.sslfactory(instance.getSslfactory());
            Optional<String> sslmodeOptional = instance.getSslmode();
            if (sslmodeOptional.isPresent()) {
                this.sslmode(sslmodeOptional);
            }
            if ((sslcertOptional = instance.getSslcert()).isPresent()) {
                this.sslcert(sslcertOptional);
            }
            if ((sslkeyOptional = instance.getSslkey()).isPresent()) {
                this.sslkey(sslkeyOptional);
            }
            if ((sslrootcertOptional = instance.getSslrootcert()).isPresent()) {
                this.sslrootcert(sslrootcertOptional);
            }
            this.database(instance.getDatabase());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(String user) {
            this.user = (String)Preconditions.checkNotNull((Object)user, (Object)"user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = Optional.of((Object)port);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(Optional<Integer> port) {
            this.port = (Optional)Preconditions.checkNotNull(port, (Object)"port");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loginTimeout(int loginTimeout) {
            this.loginTimeout = loginTimeout;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ssl(boolean ssl) {
            this.ssl = ssl;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslfactory(String sslfactory) {
            this.sslfactory = (String)Preconditions.checkNotNull((Object)sslfactory, (Object)"sslfactory");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslmode(String sslmode) {
            this.sslmode = Optional.of((Object)sslmode);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslmode(Optional<String> sslmode) {
            this.sslmode = (Optional)Preconditions.checkNotNull(sslmode, (Object)"sslmode");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslcert(String sslcert) {
            this.sslcert = Optional.of((Object)sslcert);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslcert(Optional<String> sslcert) {
            this.sslcert = (Optional)Preconditions.checkNotNull(sslcert, (Object)"sslcert");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslkey(String sslkey) {
            this.sslkey = Optional.of((Object)sslkey);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslkey(Optional<String> sslkey) {
            this.sslkey = (Optional)Preconditions.checkNotNull(sslkey, (Object)"sslkey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslrootcert(String sslrootcert) {
            this.sslrootcert = Optional.of((Object)sslrootcert);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslrootcert(Optional<String> sslrootcert) {
            this.sslrootcert = (Optional)Preconditions.checkNotNull(sslrootcert, (Object)"sslrootcert");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder database(String database) {
            this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"database");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableRemoteDatabaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRemoteDatabaseConfig(this.user, this.password, this.host, this.port, this.loginTimeout, this.socketTimeout, this.ssl, this.sslfactory, this.sslmode, this.sslcert, this.sslkey, this.sslrootcert, this.database);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("loginTimeout");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("socketTimeout");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("ssl");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("sslfactory");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("database");
            }
            return "Cannot build RemoteDatabaseConfig, some of required attributes are not set " + attributes;
        }
    }
}

