/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.RemoteDatabaseConfig;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableDatabaseConfig
implements DatabaseConfig {
    private final String type;
    private final Optional<String> path;
    private final ImmutableMap<String, String> options;
    private final Optional<RemoteDatabaseConfig> remoteDatabaseConfig;
    private final int expireLockInterval;
    private final boolean autoMigrate;
    private final int connectionTimeout;
    private final int idleTimeout;
    private final int keepaliveTime;
    private final int maximumPoolSize;
    private final int minimumPoolSize;
    private final int validationTimeout;
    private final boolean enableJMX;
    private final long leakDetectionThreshold;

    private ImmutableDatabaseConfig(String type, Optional<String> path, ImmutableMap<String, String> options, Optional<RemoteDatabaseConfig> remoteDatabaseConfig, int expireLockInterval, boolean autoMigrate, int connectionTimeout, int idleTimeout, int keepaliveTime, int maximumPoolSize, int minimumPoolSize, int validationTimeout, boolean enableJMX, long leakDetectionThreshold) {
        this.type = type;
        this.path = path;
        this.options = options;
        this.remoteDatabaseConfig = remoteDatabaseConfig;
        this.expireLockInterval = expireLockInterval;
        this.autoMigrate = autoMigrate;
        this.connectionTimeout = connectionTimeout;
        this.idleTimeout = idleTimeout;
        this.keepaliveTime = keepaliveTime;
        this.maximumPoolSize = maximumPoolSize;
        this.minimumPoolSize = minimumPoolSize;
        this.validationTimeout = validationTimeout;
        this.enableJMX = enableJMX;
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<String> getPath() {
        return this.path;
    }

    public ImmutableMap<String, String> getOptions() {
        return this.options;
    }

    @Override
    public Optional<RemoteDatabaseConfig> getRemoteDatabaseConfig() {
        return this.remoteDatabaseConfig;
    }

    @Override
    public int getExpireLockInterval() {
        return this.expireLockInterval;
    }

    @Override
    public boolean getAutoMigrate() {
        return this.autoMigrate;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getKeepaliveTime() {
        return this.keepaliveTime;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Override
    public int getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    @Override
    public int getValidationTimeout() {
        return this.validationTimeout;
    }

    @Override
    public boolean getEnableJMX() {
        return this.enableJMX;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    public final ImmutableDatabaseConfig withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        return new ImmutableDatabaseConfig(newValue, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withPath(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.path.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, (Optional<String>)newValue, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withPath(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"path");
        if (this.path.equals((Object)value)) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, (Optional<String>)value, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableDatabaseConfig(this.type, this.path, (ImmutableMap<String, String>)newValue, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withRemoteDatabaseConfig(RemoteDatabaseConfig value) {
        Optional newValue = Optional.of((Object)value);
        if (this.remoteDatabaseConfig.isPresent() && this.remoteDatabaseConfig.get() == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, (Optional<RemoteDatabaseConfig>)newValue, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withRemoteDatabaseConfig(Optional<RemoteDatabaseConfig> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"remoteDatabaseConfig");
        if (!this.remoteDatabaseConfig.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.remoteDatabaseConfig.isPresent() && value.isPresent() && this.remoteDatabaseConfig.get() == value.get()) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, (Optional<RemoteDatabaseConfig>)value, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withExpireLockInterval(int value) {
        if (this.expireLockInterval == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, value, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withAutoMigrate(boolean value) {
        if (this.autoMigrate == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, value, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withConnectionTimeout(int value) {
        if (this.connectionTimeout == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, value, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withIdleTimeout(int value) {
        if (this.idleTimeout == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, value, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withKeepaliveTime(int value) {
        if (this.keepaliveTime == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, value, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withMaximumPoolSize(int value) {
        if (this.maximumPoolSize == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, value, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withMinimumPoolSize(int value) {
        if (this.minimumPoolSize == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, value, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withValidationTimeout(int value) {
        if (this.validationTimeout == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, value, this.enableJMX, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withEnableJMX(boolean value) {
        if (this.enableJMX == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, value, this.leakDetectionThreshold);
    }

    public final ImmutableDatabaseConfig withLeakDetectionThreshold(long value) {
        if (this.leakDetectionThreshold == value) {
            return this;
        }
        return new ImmutableDatabaseConfig(this.type, this.path, this.options, this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatabaseConfig && this.equalTo((ImmutableDatabaseConfig)another);
    }

    private boolean equalTo(ImmutableDatabaseConfig another) {
        return this.type.equals(another.type) && this.path.equals(another.path) && this.options.equals(another.options) && this.remoteDatabaseConfig.equals(another.remoteDatabaseConfig) && this.expireLockInterval == another.expireLockInterval && this.autoMigrate == another.autoMigrate && this.connectionTimeout == another.connectionTimeout && this.idleTimeout == another.idleTimeout && this.keepaliveTime == another.keepaliveTime && this.maximumPoolSize == another.maximumPoolSize && this.minimumPoolSize == another.minimumPoolSize && this.validationTimeout == another.validationTimeout && this.enableJMX == another.enableJMX && this.leakDetectionThreshold == another.leakDetectionThreshold;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.path.hashCode();
        h = h * 17 + this.options.hashCode();
        h = h * 17 + this.remoteDatabaseConfig.hashCode();
        h = h * 17 + this.expireLockInterval;
        h = h * 17 + Booleans.hashCode((boolean)this.autoMigrate);
        h = h * 17 + this.connectionTimeout;
        h = h * 17 + this.idleTimeout;
        h = h * 17 + this.keepaliveTime;
        h = h * 17 + this.maximumPoolSize;
        h = h * 17 + this.minimumPoolSize;
        h = h * 17 + this.validationTimeout;
        h = h * 17 + Booleans.hashCode((boolean)this.enableJMX);
        h = h * 17 + Longs.hashCode((long)this.leakDetectionThreshold);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DatabaseConfig").omitNullValues().add("type", (Object)this.type).add("path", this.path.orNull()).add("options", this.options).add("remoteDatabaseConfig", this.remoteDatabaseConfig.orNull()).add("expireLockInterval", this.expireLockInterval).add("autoMigrate", this.autoMigrate).add("connectionTimeout", this.connectionTimeout).add("idleTimeout", this.idleTimeout).add("keepaliveTime", this.keepaliveTime).add("maximumPoolSize", this.maximumPoolSize).add("minimumPoolSize", this.minimumPoolSize).add("validationTimeout", this.validationTimeout).add("enableJMX", this.enableJMX).add("leakDetectionThreshold", this.leakDetectionThreshold).toString();
    }

    public static ImmutableDatabaseConfig copyOf(DatabaseConfig instance) {
        if (instance instanceof ImmutableDatabaseConfig) {
            return (ImmutableDatabaseConfig)instance;
        }
        return ImmutableDatabaseConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_EXPIRE_LOCK_INTERVAL = 2L;
        private static final long INIT_BIT_AUTO_MIGRATE = 4L;
        private static final long INIT_BIT_CONNECTION_TIMEOUT = 8L;
        private static final long INIT_BIT_IDLE_TIMEOUT = 16L;
        private static final long INIT_BIT_KEEPALIVE_TIME = 32L;
        private static final long INIT_BIT_MAXIMUM_POOL_SIZE = 64L;
        private static final long INIT_BIT_MINIMUM_POOL_SIZE = 128L;
        private static final long INIT_BIT_VALIDATION_TIMEOUT = 256L;
        private static final long INIT_BIT_ENABLE_J_M_X = 512L;
        private static final long INIT_BIT_LEAK_DETECTION_THRESHOLD = 1024L;
        private long initBits = 2047L;
        @Nullable
        private String type;
        private Optional<String> path = Optional.absent();
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        private Optional<RemoteDatabaseConfig> remoteDatabaseConfig = Optional.absent();
        private int expireLockInterval;
        private boolean autoMigrate;
        private int connectionTimeout;
        private int idleTimeout;
        private int keepaliveTime;
        private int maximumPoolSize;
        private int minimumPoolSize;
        private int validationTimeout;
        private boolean enableJMX;
        private long leakDetectionThreshold;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DatabaseConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.type(instance.getType());
            Optional<String> pathOptional = instance.getPath();
            if (pathOptional.isPresent()) {
                this.path(pathOptional);
            }
            this.putAllOptions(instance.getOptions());
            Optional<RemoteDatabaseConfig> remoteDatabaseConfigOptional = instance.getRemoteDatabaseConfig();
            if (remoteDatabaseConfigOptional.isPresent()) {
                this.remoteDatabaseConfig(remoteDatabaseConfigOptional);
            }
            this.expireLockInterval(instance.getExpireLockInterval());
            this.autoMigrate(instance.getAutoMigrate());
            this.connectionTimeout(instance.getConnectionTimeout());
            this.idleTimeout(instance.getIdleTimeout());
            this.keepaliveTime(instance.getKeepaliveTime());
            this.maximumPoolSize(instance.getMaximumPoolSize());
            this.minimumPoolSize(instance.getMinimumPoolSize());
            this.validationTimeout(instance.getValidationTimeout());
            this.enableJMX(instance.getEnableJMX());
            this.leakDetectionThreshold(instance.getLeakDetectionThreshold());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Optional.of((Object)path);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(Optional<String> path) {
            this.path = (Optional)Preconditions.checkNotNull(path, (Object)"path");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> options) {
            this.options = ImmutableMap.builder();
            return this.putAllOptions(options);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> options) {
            this.options.putAll(options);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remoteDatabaseConfig(RemoteDatabaseConfig remoteDatabaseConfig) {
            this.remoteDatabaseConfig = Optional.of((Object)remoteDatabaseConfig);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remoteDatabaseConfig(Optional<RemoteDatabaseConfig> remoteDatabaseConfig) {
            this.remoteDatabaseConfig = (Optional)Preconditions.checkNotNull(remoteDatabaseConfig, (Object)"remoteDatabaseConfig");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expireLockInterval(int expireLockInterval) {
            this.expireLockInterval = expireLockInterval;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder autoMigrate(boolean autoMigrate) {
            this.autoMigrate = autoMigrate;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder idleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keepaliveTime(int keepaliveTime) {
            this.keepaliveTime = keepaliveTime;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minimumPoolSize(int minimumPoolSize) {
            this.minimumPoolSize = minimumPoolSize;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validationTimeout(int validationTimeout) {
            this.validationTimeout = validationTimeout;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableJMX(boolean enableJMX) {
            this.enableJMX = enableJMX;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder leakDetectionThreshold(long leakDetectionThreshold) {
            this.leakDetectionThreshold = leakDetectionThreshold;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public ImmutableDatabaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatabaseConfig(this.type, this.path, this.options.build(), this.remoteDatabaseConfig, this.expireLockInterval, this.autoMigrate, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maximumPoolSize, this.minimumPoolSize, this.validationTimeout, this.enableJMX, this.leakDetectionThreshold);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expireLockInterval");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("autoMigrate");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("connectionTimeout");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("idleTimeout");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("keepaliveTime");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("maximumPoolSize");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("minimumPoolSize");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("validationTimeout");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("enableJMX");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("leakDetectionThreshold");
            }
            return "Cannot build DatabaseConfig, some of required attributes are not set " + attributes;
        }
    }
}

