/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.client.config.ConfigKey;
import io.digdag.core.database.BasicDatabaseStoreManager;
import io.digdag.core.database.ConfigKeyListMapper;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceLimitExceededException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.session.ArchivedTask;
import io.digdag.core.session.AttemptStateFlags;
import io.digdag.core.session.DelayedAttemptControlStore;
import io.digdag.core.session.ImmutableArchivedTask;
import io.digdag.core.session.ImmutableResumingTask;
import io.digdag.core.session.ImmutableSession;
import io.digdag.core.session.ImmutableSessionAttemptSummary;
import io.digdag.core.session.ImmutableStoredDelayedSessionAttempt;
import io.digdag.core.session.ImmutableStoredSession;
import io.digdag.core.session.ImmutableStoredSessionAttempt;
import io.digdag.core.session.ImmutableStoredSessionAttemptWithSession;
import io.digdag.core.session.ImmutableStoredSessionMonitor;
import io.digdag.core.session.ImmutableStoredSessionWithLastAttempt;
import io.digdag.core.session.ImmutableStoredTask;
import io.digdag.core.session.ImmutableTask;
import io.digdag.core.session.ImmutableTaskAttemptSummary;
import io.digdag.core.session.ImmutableTaskRelation;
import io.digdag.core.session.ImmutableTaskStateSummary;
import io.digdag.core.session.ParameterUpdate;
import io.digdag.core.session.ResumingTask;
import io.digdag.core.session.Session;
import io.digdag.core.session.SessionAttempt;
import io.digdag.core.session.SessionAttemptControlStore;
import io.digdag.core.session.SessionAttemptSummary;
import io.digdag.core.session.SessionControlStore;
import io.digdag.core.session.SessionMonitor;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.SessionTransaction;
import io.digdag.core.session.StoredDelayedSessionAttempt;
import io.digdag.core.session.StoredSession;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.core.session.StoredSessionMonitor;
import io.digdag.core.session.StoredSessionWithLastAttempt;
import io.digdag.core.session.StoredTask;
import io.digdag.core.session.Task;
import io.digdag.core.session.TaskAttemptSummary;
import io.digdag.core.session.TaskControlStore;
import io.digdag.core.session.TaskRelation;
import io.digdag.core.session.TaskStateCode;
import io.digdag.core.session.TaskStateFlags;
import io.digdag.core.session.TaskStateSummary;
import io.digdag.core.session.TaskType;
import io.digdag.core.workflow.TaskConfig;
import io.digdag.metrics.DigdagTimed;
import io.digdag.spi.TaskReport;
import io.digdag.spi.TaskResult;
import io.digdag.spi.ac.AccessController;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Define;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class DatabaseSessionStoreManager
extends BasicDatabaseStoreManager<Dao>
implements SessionStoreManager {
    private static final String DEFAULT_ATTEMPT_NAME = "";
    private final ObjectMapper taskArchiveMapper;
    private final ConfigFactory cf;
    private final ConfigKeyListMapper cklm = new ConfigKeyListMapper();
    private final StoredTaskMapper stm;
    private final ArchivedTaskMapper atm;
    private final TaskAttemptSummaryMapper tasm;

    @Inject
    public DatabaseSessionStoreManager(ConfigFactory cf, TransactionManager transactionManager, ConfigMapper cfm, ObjectMapper mapper, DatabaseConfig config) {
        super(config.getType(), DatabaseSessionStoreManager.dao(config.getType()), transactionManager, cfm);
        this.taskArchiveMapper = mapper.copy();
        this.taskArchiveMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.cf = cf;
        this.stm = new StoredTaskMapper(cfm);
        this.atm = new ArchivedTaskMapper(this.cklm, cfm);
        this.tasm = new TaskAttemptSummaryMapper();
    }

    private static Class<? extends Dao> dao(String type) {
        switch (type) {
            case "postgresql": {
                return PgDao.class;
            }
            case "h2": {
                return H2Dao.class;
            }
        }
        throw new IllegalArgumentException("Unknown database type: " + type);
    }

    private String bitAnd(String op1, String op2) {
        switch (this.databaseType) {
            case "h2": {
                return "BITAND(" + op1 + ", " + op2 + ")";
            }
        }
        return op1 + " & " + op2;
    }

    private String bitOr(String op1, String op2) {
        switch (this.databaseType) {
            case "h2": {
                return "BITOR(" + op1 + ", " + op2 + ")";
            }
        }
        return op1 + " | " + op2;
    }

    private String commaGroupConcat(String column) {
        switch (this.databaseType) {
            case "h2": {
                return "group_concat(" + column + " separator ',')";
            }
        }
        return "array_to_string(array_agg(" + column + "), ',')";
    }

    private String addSeconds(String timestampExpression, int seconds) {
        if (seconds == 0) {
            return timestampExpression;
        }
        switch (this.databaseType) {
            case "h2": {
                return "dateadd('SECOND', " + seconds + ", " + timestampExpression + ")";
            }
        }
        return "(" + timestampExpression + " + interval '" + seconds + " second')";
    }

    private String selectTaskDetailsQuery() {
        return "select t.*, td.full_name, td.local_config, td.export_config, (select " + this.commaGroupConcat("upstream_id") + " from task_dependencies where downstream_id = t.id) as upstream_ids from tasks t join session_attempts sa on sa.id = t.attempt_id join task_details td on t.id = td.id";
    }

    @Override
    public SessionStore getSessionStore(int siteId) {
        return new DatabaseSessionStore(siteId);
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public Instant getStoreTime() {
        return this.autoCommit((handle, dao) -> dao.now());
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public int getSiteIdOfTask(long taskId) throws ResourceNotFoundException {
        return this.requiredResource((handle, dao) -> dao.getSiteIdOfTask(taskId), "session attempt of task id=%d", new Object[]{taskId});
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public StoredSessionAttemptWithSession getAttemptWithSessionById(long attemptId) throws ResourceNotFoundException {
        return this.requiredResource((handle, dao) -> dao.getAttemptWithSessionByIdInternal(attemptId), "session attempt id=%d", new Object[]{attemptId});
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public AttemptStateFlags getAttemptStateFlags(long attemptId) throws ResourceNotFoundException {
        int stateFlags = this.requiredResource((handle, dao) -> (Integer)((Query)handle.createQuery("select state_flags from session_attempts sa join sessions s on s.id = sa.session_id where sa.id = :id").bind("id", attemptId)).mapTo(Integer.class).first(), "session attempt id=%d", new Object[]{attemptId});
        return AttemptStateFlags.of(stateFlags);
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public boolean isAnyNotDoneAttempts() {
        return this.autoCommit((handle, dao) -> (Long)handle.createQuery("select count(*) from session_attempts sa join sessions s on s.id = sa.session_id where " + this.bitAnd("state_flags", Integer.toString(2)) + " = 0").mapTo(Long.TYPE).first() > 0L);
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<Long> findAllReadyTaskIds(int maxEntries, boolean randomFetch) {
        if (randomFetch) {
            return this.autoCommit((handle, dao) -> dao.findAllTaskIdsByStateAtRandom(TaskStateCode.READY.get(), maxEntries));
        }
        return this.autoCommit((handle, dao) -> dao.findAllTaskIdsByState(TaskStateCode.READY.get(), maxEntries));
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<StoredSessionAttempt> findActiveAttemptsCreatedBefore(Instant createdBefore, long lastId, int limit) {
        return this.autoCommit((handle, dao) -> dao.findActiveAttemptsCreatedBefore(DatabaseSessionStoreManager.sqlTimestampOf(createdBefore), lastId, limit));
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<TaskAttemptSummary> findTasksStartedBeforeWithState(TaskStateCode[] states, Instant startedBefore, long lastId, int limit) {
        return this.autoCommit((handle, dao) -> ((Query)((Query)((Query)handle.createQuery("select id, attempt_id, state from tasks where state in (" + Stream.of(states).map(it -> Short.toString(it.get())).collect(Collectors.joining(", ")) + ") and " + this.bitAnd("state_flags", Integer.toString(1)) + " = 0 and started_at < :startedBefore and id > :lastId order by id asc limit :limit").bind("startedBefore", DatabaseSessionStoreManager.sqlTimestampOf(startedBefore))).bind("lastId", lastId)).bind("limit", limit)).map((ResultSetMapper)this.tasm).list());
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public <T> Optional<T> lockAttemptIfExists(long attemptId, SessionStoreManager.AttemptLockAction<T> func) {
        return this.transaction((handle, dao) -> {
            SessionAttemptSummary locked = dao.lockAttempt(attemptId);
            if (locked != null) {
                return Optional.of(func.call(new DatabaseSessionAttemptControlStore(handle), locked));
            }
            return Optional.absent();
        });
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<TaskStateSummary> findRecentlyChangedTasks(Instant updatedSince, long lastId) {
        return this.autoCommit((handle, dao) -> dao.findRecentlyChangedTasks(updatedSince, lastId, 100));
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<Long> findTasksByState(TaskStateCode state, long lastId) {
        return this.autoCommit((handle, dao) -> dao.findTasksByState(state.get(), lastId, 100));
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<TaskAttemptSummary> findRootTasksByStates(TaskStateCode[] states, long lastId) {
        return this.autoCommit((handle, dao) -> ((Query)((Query)handle.createQuery("select id, attempt_id, state from tasks where parent_id is null and state in (" + Stream.of(states).map(it -> Short.toString(it.get())).collect(Collectors.joining(", ")) + ") and id > :lastId order by id asc limit :limit").bind("lastId", lastId)).bind("limit", 100)).map((ResultSetMapper)this.tasm).list());
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<Long> findDirectParentsOfBlockedTasks(long lastId) {
        return this.autoCommit((handle, dao) -> ((Query)((Query)handle.createQuery("select distinct parent_id from tasks where parent_id > :lastId and state = 0 order by parent_id limit :limit").bind("lastId", lastId)).bind("limit", 100)).mapTo(Long.class).list());
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public boolean requestCancelAttempt(long attemptId) {
        return this.transaction((handle, dao) -> {
            ((Query)handle.createQuery("select id from tasks where attempt_id = :attemptId and state = 4 for update").bind("attemptId", attemptId)).mapTo(Long.class).list();
            int n = ((Update)handle.createStatement("update tasks set state_flags = " + this.bitOr("state_flags", Integer.toString(1)) + " where attempt_id = :attemptId and state in (" + Stream.of(TaskStateCode.notDoneStates()).map(it -> Short.toString(it.get())).collect(Collectors.joining(", ")) + ")").bind("attemptId", attemptId)).execute();
            if (n > 0) {
                ((Update)handle.createStatement("update session_attempts set state_flags = " + this.bitOr("state_flags", Integer.toString(1)) + " where id = :attemptId").bind("attemptId", attemptId)).execute();
            }
            return n > 0;
        });
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public int trySetRetryWaitingToReady() {
        return this.autoCommit((handle, dao) -> dao.trySetRetryWaitingToReady());
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public <T> Optional<T> lockTaskIfExists(long taskId, SessionStoreManager.TaskLockAction<T> func) {
        return this.lockTask(taskId, func, false);
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public <T> Optional<T> lockTaskIfNotLocked(long taskId, SessionStoreManager.TaskLockAction<T> func) {
        return this.lockTask(taskId, func, true);
    }

    private <T> Optional<T> lockTask(long taskId, SessionStoreManager.TaskLockAction<T> func, boolean ifNotLocked) {
        return this.transaction((handle, dao) -> {
            Long locked;
            Long l = locked = ifNotLocked ? dao.lockTaskIfNotLocked(taskId) : dao.lockTask(taskId);
            if (locked != null) {
                Object result = func.call(new DatabaseTaskControlStore(handle));
                return Optional.of(result);
            }
            return Optional.absent();
        });
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public <T> Optional<T> lockTaskIfExists(long taskId, SessionStoreManager.TaskLockActionWithDetails<T> func) {
        return this.lockTaskWithDetails(taskId, func, false);
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public <T> Optional<T> lockTaskIfNotLocked(long taskId, SessionStoreManager.TaskLockActionWithDetails<T> func) {
        return this.lockTaskWithDetails(taskId, func, true);
    }

    private <T> Optional<T> lockTaskWithDetails(long taskId, SessionStoreManager.TaskLockActionWithDetails<T> func, boolean ifNotLocked) {
        return this.transaction((handle, dao) -> {
            Long locked;
            Long l = locked = ifNotLocked ? dao.lockTaskIfNotLocked(taskId) : dao.lockTask(taskId);
            if (locked != null) {
                try {
                    StoredTask task = this.getTaskById(handle, taskId);
                    Object result = func.call(new DatabaseTaskControlStore(handle), task);
                    return Optional.of(result);
                }
                catch (ResourceNotFoundException ex) {
                    throw new IllegalStateException("Database state error", ex);
                }
            }
            return Optional.absent();
        });
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public void lockReadySessionMonitors(Instant currentTime, SessionStoreManager.SessionMonitorAction func) {
        List exceptions = this.transaction((handle, dao) -> dao.lockReadySessionMonitors(currentTime.getEpochSecond(), 10).stream().map(monitor -> {
            try {
                Optional<Instant> nextRunTime = func.schedule((StoredSessionMonitor)monitor);
                if (nextRunTime.isPresent()) {
                    dao.updateNextSessionMonitorRunTime(monitor.getId(), ((Instant)nextRunTime.get()).getEpochSecond());
                } else {
                    dao.deleteSessionMonitor(monitor.getId());
                }
                return null;
            }
            catch (RuntimeException ex) {
                return ex;
            }
        }).filter(exception -> exception != null).collect(Collectors.toList()));
        if (!exceptions.isEmpty()) {
            RuntimeException first = (RuntimeException)exceptions.get(0);
            for (RuntimeException ex : exceptions.subList(1, exceptions.size())) {
                first.addSuppressed(ex);
            }
            throw first;
        }
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<TaskRelation> getTaskRelations(long attemptId) {
        return this.autoCommit((handle, dao) -> ((Query)handle.createQuery("select id, parent_id, (select " + this.commaGroupConcat("upstream_id") + " from task_dependencies where downstream_id = t.id) as upstream_ids from tasks t where attempt_id = :attemptId").bind("attemptId", attemptId)).map((ResultSetMapper)new TaskRelationMapper()).list());
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<Config> getExportParams(List<Long> idList) {
        if (idList.isEmpty()) {
            return ImmutableList.of();
        }
        List list = this.autoCommit((handle, dao) -> handle.createQuery("select td.id, td.export_config, ts.export_params from task_details td join task_state_details ts on ts.id = td.id where td.id " + this.inLargeIdListExpression(idList)).map((ResultSetMapper)new IdConfigMapper(this.cklm, null, this.configMapper, "export_config", "export_params")).list());
        return this.sortConfigListByIdList(idList, list);
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<ParameterUpdate> getStoreParams(List<Long> idList) {
        if (idList.isEmpty()) {
            return ImmutableList.of();
        }
        List list = this.autoCommit((handle, dao) -> handle.createQuery("select id, store_params, reset_store_params from task_state_details where id " + this.inLargeIdListExpression(idList)).map((ResultSetMapper)new IdConfigMapper(this.cklm, "reset_store_params", this.configMapper, "store_params", null)).list());
        return this.sortParameterUpdateListByIdList(idList, list);
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public List<Config> getErrors(List<Long> idList) {
        if (idList.isEmpty()) {
            return ImmutableList.of();
        }
        List list = this.autoCommit((handle, dao) -> handle.createQuery("select id, error from task_state_details where id " + this.inLargeIdListExpression(idList)).map((ResultSetMapper)new IdConfigMapper(this.cklm, null, this.configMapper, "error", null)).list());
        return this.sortConfigListByIdList(idList, list);
    }

    private List<Config> sortConfigListByIdList(List<Long> idList, List<IdConfig> list) {
        HashMap<Long, Config> map = new HashMap<Long, Config>();
        for (IdConfig idConfig : list) {
            map.put(idConfig.id, idConfig.config);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long id : idList) {
            Config config = (Config)map.get(id);
            if (config == null) {
                config = this.cf.create();
            }
            builder.add((Object)config);
        }
        return builder.build();
    }

    private List<ParameterUpdate> sortParameterUpdateListByIdList(List<Long> idList, List<IdConfig> list) {
        HashMap<Long, ParameterUpdate> map = new HashMap<Long, ParameterUpdate>();
        for (IdConfig idConfig : list) {
            map.put(idConfig.id, new ParameterUpdate(idConfig.resetKeys, idConfig.config));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long id : idList) {
            ParameterUpdate update = (ParameterUpdate)map.get(id);
            if (update == null) {
                update = new ParameterUpdate((List<ConfigKey>)ImmutableList.of(), this.cf.create());
            }
            builder.add((Object)update);
        }
        return builder.build();
    }

    private String dumpTaskArchive(List<ArchivedTask> tasks) {
        try {
            return this.taskArchiveMapper.writeValueAsString(tasks);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @VisibleForTesting
    List<ArchivedTask> loadTaskArchive(String data) {
        try {
            return (List)this.taskArchiveMapper.readValue(data, this.taskArchiveMapper.getTypeFactory().constructParametrizedType(List.class, List.class, new Class[]{ArchivedTask.class}));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load task archive", ex);
        }
    }

    @Override
    @DigdagTimed(value="dssm_", category="db", appendMethodName=true)
    public void lockReadyDelayedAttempts(Instant currentTime, SessionStoreManager.DelayedAttemptAction func) {
        List exceptions = this.transaction((handle, dao) -> {
            List locked = ((Query)((Query)handle.createQuery("select da.* from delayed_session_attempts da where not exists ( select * from session_attempts sa where sa.session_id = da.dependent_session_id and " + this.bitAnd("sa.state_flags", Integer.toString(2)) + " = 0) and next_run_time <= :currentTime order by next_run_time limit :limit for update").bind("limit", 10)).bind("currentTime", currentTime.getEpochSecond())).mapTo(StoredDelayedSessionAttempt.class).list();
            return locked.stream().map(delayedAttempt -> {
                try {
                    func.submit(new DatabaseDelayedAttemptControlStore(handle), (StoredDelayedSessionAttempt)delayedAttempt);
                    return null;
                }
                catch (RuntimeException ex) {
                    return ex;
                }
            }).filter(exception -> exception != null).collect(Collectors.toList());
        });
        if (!exceptions.isEmpty()) {
            RuntimeException first = (RuntimeException)exceptions.get(0);
            for (RuntimeException ex : exceptions.subList(1, exceptions.size())) {
                first.addSuppressed(ex);
            }
            throw first;
        }
    }

    private StoredTask getTaskById(Handle handle, long taskId) throws ResourceNotFoundException {
        return (StoredTask)this.requiredResource(((Query)handle.createQuery(this.selectTaskDetailsQuery() + " where t.id = :id").bind("id", taskId)).map((ResultSetMapper)this.stm).first(), "task id=%d", taskId);
    }

    static TaskReport taskReportFromConfig(Config config) {
        return TaskReport.builder().inputs((Iterable)config.getListOrEmpty("in", Config.class)).outputs((Iterable)config.getListOrEmpty("out", Config.class)).build();
    }

    static Config taskReportToConfig(ConfigFactory cf, TaskReport report) {
        return cf.create().set("in", (Object)report.getInputs()).set("out", (Object)report.getOutputs());
    }

    private static Timestamp sqlTimestampOf(Instant instant) {
        Timestamp t = new Timestamp(instant.getEpochSecond() * 1000L);
        t.setNanos(instant.getNano());
        return t;
    }

    static class ConfigResultSetMapper
    implements ResultSetMapper<Config> {
        private final ConfigMapper cfm;
        private final String column;

        public ConfigResultSetMapper(ConfigMapper cfm, String column) {
            this.cfm = cfm;
            this.column = column;
        }

        public Config map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return this.cfm.fromResultSetOrEmpty(r, this.column);
        }
    }

    static class IdConfigMapper
    implements ResultSetMapper<IdConfig> {
        private final ConfigKeyListMapper cklm;
        private final String resetKeysColumn;
        private final ConfigMapper cfm;
        private final String configColumn;
        private final String mergeColumn;

        public IdConfigMapper(ConfigKeyListMapper cklm, String resetKeysColumn, ConfigMapper cfm, String configColumn, String mergeColumn) {
            this.cklm = cklm;
            this.cfm = cfm;
            this.resetKeysColumn = resetKeysColumn;
            this.configColumn = configColumn;
            this.mergeColumn = mergeColumn;
        }

        public IdConfig map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            List<ConfigKey> resetKeys = null;
            if (this.resetKeysColumn != null) {
                resetKeys = this.cklm.fromResultSetOrEmpty(r, this.resetKeysColumn);
            }
            Config config = this.cfm.fromResultSetOrEmpty(r, this.configColumn);
            if (this.mergeColumn != null) {
                config.merge(this.cfm.fromResultSetOrEmpty(r, this.mergeColumn));
            }
            return new IdConfig(r.getLong("id"), resetKeys, config);
        }
    }

    private static class IdConfig {
        protected final long id;
        protected final Config config;
        private final List<ConfigKey> resetKeys;

        public IdConfig(long id, List<ConfigKey> resetKeys, Config config) {
            this.id = id;
            this.resetKeys = resetKeys;
            this.config = config;
        }
    }

    static class StoredDelayedSessionAttemptMapper
    implements ResultSetMapper<StoredDelayedSessionAttempt> {
        StoredDelayedSessionAttemptMapper() {
        }

        public StoredDelayedSessionAttempt map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableStoredDelayedSessionAttempt.builder().attemptId(r.getLong("id")).dependentSessionId(BasicDatabaseStoreManager.getOptionalLong(r, "dependent_session_id")).nextRunTime(Instant.ofEpochSecond(r.getLong("next_run_time"))).updatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "updated_at")).build();
        }
    }

    static class StoredSessionMonitorMapper
    implements ResultSetMapper<StoredSessionMonitor> {
        private final ConfigMapper cfm;

        public StoredSessionMonitorMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredSessionMonitor map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableStoredSessionMonitor.builder().id(r.getLong("id")).attemptId(r.getLong("attempt_id")).nextRunTime(Instant.ofEpochSecond(r.getLong("next_run_time"))).type(r.getString("type")).config(this.cfm.fromResultSetOrEmpty(r, "config")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).updatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "updated_at")).build();
        }
    }

    static class TaskRelationMapper
    implements ResultSetMapper<TaskRelation> {
        TaskRelationMapper() {
        }

        public TaskRelation map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableTaskRelation.builder().id(r.getInt("id")).parentId(BasicDatabaseStoreManager.getOptionalLong(r, "parent_id")).upstreams(BasicDatabaseStoreManager.getLongIdList(r, "upstream_ids")).build();
        }
    }

    static class TaskAttemptSummaryMapper
    implements ResultSetMapper<TaskAttemptSummary> {
        TaskAttemptSummaryMapper() {
        }

        public TaskAttemptSummary map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableTaskAttemptSummary.builder().id(r.getLong("id")).attemptId(r.getLong("attempt_id")).state(TaskStateCode.of(r.getInt("state"))).build();
        }
    }

    static class TaskStateSummaryMapper
    implements ResultSetMapper<TaskStateSummary> {
        TaskStateSummaryMapper() {
        }

        public TaskStateSummary map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableTaskStateSummary.builder().id(r.getLong("id")).parentId(BasicDatabaseStoreManager.getOptionalLong(r, "parent_id")).state(TaskStateCode.of(r.getInt("state"))).updatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "updated_at")).build();
        }
    }

    static class ResumingTaskMapper
    implements ResultSetMapper<ResumingTask> {
        private final ConfigKeyListMapper cklm;
        private final ConfigMapper cfm;

        public ResumingTaskMapper(ConfigKeyListMapper cklm, ConfigMapper cfm) {
            this.cklm = cklm;
            this.cfm = cfm;
        }

        public ResumingTask map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            TaskReport report = DatabaseSessionStoreManager.taskReportFromConfig(this.cfm.fromResultSetOrEmpty(r, "report"));
            return ImmutableResumingTask.builder().sourceTaskId(r.getLong("source_task_id")).fullName(r.getString("full_name")).updatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "updated_at")).config(TaskConfig.assumeValidated(this.cfm.fromResultSetOrEmpty(r, "local_config"), this.cfm.fromResultSetOrEmpty(r, "export_config"))).subtaskConfig(this.cfm.fromResultSetOrEmpty(r, "subtask_config")).exportParams(this.cfm.fromResultSetOrEmpty(r, "export_params")).resetStoreParams(this.cklm.fromResultSetOrEmpty(r, "reset_store_params")).storeParams(this.cfm.fromResultSetOrEmpty(r, "store_params")).report(report).error(this.cfm.fromResultSetOrEmpty(r, "error")).build();
        }
    }

    static class ArchivedTaskMapper
    implements ResultSetMapper<ArchivedTask> {
        private final ConfigKeyListMapper cklm;
        private final ConfigMapper cfm;

        public ArchivedTaskMapper(ConfigKeyListMapper cklm, ConfigMapper cfm) {
            this.cklm = cklm;
            this.cfm = cfm;
        }

        public ArchivedTask map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            TaskReport report = DatabaseSessionStoreManager.taskReportFromConfig(this.cfm.fromResultSetOrEmpty(r, "report"));
            return ImmutableArchivedTask.builder().id(r.getLong("id")).upstreams(BasicDatabaseStoreManager.getLongIdList(r, "upstream_ids")).updatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "updated_at")).retryAt(BasicDatabaseStoreManager.getOptionalTimestampInstant(r, "retry_at")).startedAt(BasicDatabaseStoreManager.getOptionalTimestampInstant(r, "started_at")).stateParams(this.cfm.fromResultSetOrEmpty(r, "state_params")).retryCount(r.getInt("retry_count")).attemptId(r.getLong("attempt_id")).parentId(BasicDatabaseStoreManager.getOptionalLong(r, "parent_id")).fullName(r.getString("full_name")).config(TaskConfig.assumeValidated(this.cfm.fromResultSetOrEmpty(r, "local_config"), this.cfm.fromResultSetOrEmpty(r, "export_config"))).taskType(TaskType.of(r.getInt("task_type"))).state(TaskStateCode.of(r.getInt("state"))).stateFlags(TaskStateFlags.of(r.getInt("state_flags"))).subtaskConfig(this.cfm.fromResultSetOrEmpty(r, "subtask_config")).exportParams(this.cfm.fromResultSetOrEmpty(r, "export_params")).resetStoreParams(this.cklm.fromResultSetOrEmpty(r, "reset_store_params")).storeParams(this.cfm.fromResultSetOrEmpty(r, "store_params")).report(report).error(this.cfm.fromResultSetOrEmpty(r, "error")).resumingTaskId(BasicDatabaseStoreManager.getOptionalLong(r, "resuming_task_id")).build();
        }
    }

    static class StoredTaskMapper
    implements ResultSetMapper<StoredTask> {
        private final ConfigMapper cfm;

        public StoredTaskMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredTask map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableStoredTask.builder().id(r.getLong("id")).upstreams(BasicDatabaseStoreManager.getLongIdList(r, "upstream_ids")).updatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "updated_at")).retryAt(BasicDatabaseStoreManager.getOptionalTimestampInstant(r, "retry_at")).startedAt(BasicDatabaseStoreManager.getOptionalTimestampInstant(r, "started_at")).stateParams(this.cfm.fromResultSetOrEmpty(r, "state_params")).retryCount(r.getInt("retry_count")).attemptId(r.getLong("attempt_id")).parentId(BasicDatabaseStoreManager.getOptionalLong(r, "parent_id")).fullName(r.getString("full_name")).config(TaskConfig.assumeValidated(this.cfm.fromResultSetOrEmpty(r, "local_config"), this.cfm.fromResultSetOrEmpty(r, "export_config"))).taskType(TaskType.of(r.getInt("task_type"))).state(TaskStateCode.of(r.getInt("state"))).stateFlags(TaskStateFlags.of(r.getInt("state_flags"))).build();
        }
    }

    static class SessionAttemptSummaryMapper
    implements ResultSetMapper<SessionAttemptSummary> {
        SessionAttemptSummaryMapper() {
        }

        public SessionAttemptSummary map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableSessionAttemptSummary.builder().id(r.getLong("id")).sessionId(r.getLong("session_id")).stateFlags(AttemptStateFlags.of(r.getInt("state_flags"))).index(r.getInt("index")).build();
        }
    }

    static class StoredSessionWithLastAttemptMapper
    implements ResultSetMapper<StoredSessionWithLastAttempt> {
        private final ConfigMapper cfm;

        public StoredSessionWithLastAttemptMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredSessionWithLastAttempt map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String attemptName = r.getString("attempt_name");
            return ImmutableStoredSessionWithLastAttempt.builder().id(r.getLong("id")).projectId(r.getInt("project_id")).lastAttemptId(r.getLong("last_attempt_id")).lastAttempt(ImmutableStoredSessionAttempt.builder().id(r.getLong("last_attempt_id")).index(r.getInt("index")).retryAttemptName((Optional<String>)(DatabaseSessionStoreManager.DEFAULT_ATTEMPT_NAME.equals(attemptName) ? Optional.absent() : Optional.of((Object)attemptName))).workflowDefinitionId(BasicDatabaseStoreManager.getOptionalLong(r, "workflow_definition_id")).sessionId(r.getLong("id")).stateFlags(AttemptStateFlags.of(r.getInt("state_flags"))).timeZone(ZoneId.of(r.getString("timezone"))).params(this.cfm.fromResultSetOrEmpty(r, "params")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).finishedAt(BasicDatabaseStoreManager.getOptionalTimestampInstant(r, "finished_at")).build()).siteId(r.getInt("site_id")).uuid(BasicDatabaseStoreManager.getUuid(r, "session_uuid")).workflowName(r.getString("workflow_name")).sessionTime(Instant.ofEpochSecond(r.getLong("session_time"))).build();
        }
    }

    static class StoredSessionAttemptWithSessionMapper
    implements ResultSetMapper<StoredSessionAttemptWithSession> {
        private final ConfigMapper cfm;

        public StoredSessionAttemptWithSessionMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredSessionAttemptWithSession map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String attemptName = r.getString("attempt_name");
            return ImmutableStoredSessionAttemptWithSession.builder().id(r.getLong("id")).sessionId(r.getLong("session_id")).index(r.getInt("index")).retryAttemptName((Optional<String>)(DatabaseSessionStoreManager.DEFAULT_ATTEMPT_NAME.equals(attemptName) ? Optional.absent() : Optional.of((Object)attemptName))).workflowDefinitionId(BasicDatabaseStoreManager.getOptionalLong(r, "workflow_definition_id")).stateFlags(AttemptStateFlags.of(r.getInt("state_flags"))).timeZone(ZoneId.of(r.getString("timezone"))).params(this.cfm.fromResultSetOrEmpty(r, "params")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).finishedAt(BasicDatabaseStoreManager.getOptionalTimestampInstant(r, "finished_at")).siteId(r.getInt("site_id")).sessionUuid(BasicDatabaseStoreManager.getUuid(r, "session_uuid")).session(ImmutableSession.builder().projectId(r.getInt("project_id")).workflowName(r.getString("workflow_name")).sessionTime(Instant.ofEpochSecond(r.getLong("session_time"))).build()).build();
        }
    }

    static class StoredSessionAttemptMapper
    implements ResultSetMapper<StoredSessionAttempt> {
        private final ConfigMapper cfm;

        public StoredSessionAttemptMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredSessionAttempt map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String attemptName = r.getString("attempt_name");
            return ImmutableStoredSessionAttempt.builder().id(r.getLong("id")).sessionId(r.getLong("session_id")).index(r.getInt("index")).retryAttemptName((Optional<String>)(DatabaseSessionStoreManager.DEFAULT_ATTEMPT_NAME.equals(attemptName) ? Optional.absent() : Optional.of((Object)attemptName))).workflowDefinitionId(BasicDatabaseStoreManager.getOptionalLong(r, "workflow_definition_id")).stateFlags(AttemptStateFlags.of(r.getInt("state_flags"))).timeZone(ZoneId.of(r.getString("timezone"))).params(this.cfm.fromResultSetOrEmpty(r, "params")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).finishedAt(BasicDatabaseStoreManager.getOptionalTimestampInstant(r, "finished_at")).build();
        }
    }

    static class StoredSessionMapper
    implements ResultSetMapper<StoredSession> {
        private final ConfigMapper cfm;

        public StoredSessionMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredSession map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableStoredSession.builder().id(r.getLong("id")).projectId(r.getInt("project_id")).workflowName(r.getString("workflow_name")).sessionTime(Instant.ofEpochSecond(r.getLong("session_time"))).uuid(BasicDatabaseStoreManager.getUuid(r, "session_uuid")).lastAttemptId(r.getLong("last_attempt_id")).build();
        }
    }

    static class InstantMapper
    implements ResultSetMapper<Instant> {
        InstantMapper() {
        }

        public Instant map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            Timestamp t = r.getTimestamp("date");
            if (t == null) {
                return null;
            }
            return t.toInstant();
        }
    }

    public static interface Dao {
        @SqlQuery(value="select now() as date")
        public Instant now();

        public List<StoredSessionWithLastAttempt> getSessions(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") long var3, @Define(value="acFilter") String var5);

        @SqlQuery(value="select s.*, sa.site_id, sa.attempt_name, sa.workflow_definition_id, sa.state_flags, sa.timezone, sa.params, sa.created_at, sa.finished_at, sa.index from sessions s join session_attempts sa on sa.id = s.last_attempt_id where s.id = :id and sa.site_id = :siteId")
        public StoredSessionWithLastAttempt getSession(@Bind(value="siteId") int var1, @Bind(value="id") long var2);

        @SqlQuery(value="select s.*, sa.site_id, sa.attempt_name, sa.workflow_definition_id, sa.state_flags, sa.timezone, sa.params, sa.created_at, sa.finished_at, sa.index from sessions s join session_attempts sa on sa.id = s.last_attempt_id join projects proj on proj.id = s.project_id where s.project_id = :projId and sa.site_id = :siteId and s.id \\< :lastId and <acFilter> order by s.id desc limit :limit")
        public List<StoredSessionWithLastAttempt> getSessionsOfProject(@Bind(value="siteId") int var1, @Bind(value="projId") int var2, @Bind(value="limit") int var3, @Bind(value="lastId") long var4, @Define(value="acFilter") String var6);

        @SqlQuery(value="select s.*, sa.site_id, sa.attempt_name, sa.workflow_definition_id, sa.state_flags, sa.timezone, sa.params, sa.created_at, sa.finished_at, sa.index from sessions s join session_attempts sa on sa.id = s.last_attempt_id join projects proj on proj.id = s.project_id where s.project_id = :projId and s.workflow_name = :workflowName and sa.site_id = :siteId and s.id \\< :lastId and <acFilter> order by s.id desc limit :limit")
        public List<StoredSessionWithLastAttempt> getSessionsOfWorkflowByName(@Bind(value="siteId") int var1, @Bind(value="projId") int var2, @Bind(value="workflowName") String var3, @Bind(value="limit") int var4, @Bind(value="lastId") long var5, @Define(value="acFilter") String var7);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.last_attempt_id = sa.id join projects proj on proj.id = sa.project_id where sa.site_id = :siteId and sa.id \\< :lastId and <acFilter> order by sa.id desc limit :limit")
        public List<StoredSessionAttemptWithSession> getAttempts(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") long var3, @Define(value="acFilter") String var5);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.id = sa.session_id join projects proj on proj.id = sa.project_id where sa.site_id = :siteId and s.last_attempt_id is not null and sa.id \\< :lastId and <acFilter> order by sa.id desc limit :limit")
        public List<StoredSessionAttemptWithSession> getAttemptsWithRetries(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") long var3, @Define(value="acFilter") String var5);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.last_attempt_id = sa.id join projects proj on proj.id = sa.project_id where sa.project_id = :projId and sa.site_id = :siteId and sa.id \\< :lastId and <acFilter> order by sa.id desc limit :limit")
        public List<StoredSessionAttemptWithSession> getAttemptsOfProject(@Bind(value="siteId") int var1, @Bind(value="projId") int var2, @Bind(value="limit") int var3, @Bind(value="lastId") long var4, @Define(value="acFilter") String var6);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.id = sa.session_id join projects proj on proj.id = sa.project_id where sa.project_id = :projId and sa.site_id = :siteId and s.last_attempt_id is not null and sa.id \\< :lastId and <acFilter> order by sa.id desc limit :limit")
        public List<StoredSessionAttemptWithSession> getAttemptsOfProjectWithRetries(@Bind(value="siteId") int var1, @Bind(value="projId") int var2, @Bind(value="limit") int var3, @Bind(value="lastId") long var4, @Define(value="acFilter") String var6);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.last_attempt_id = sa.id join projects proj on proj.id = sa.project_id where s.project_id = :projectId and s.workflow_name = :workflowName and sa.site_id = :siteId and sa.id \\< :lastId and <acFilter> order by sa.id desc limit :limit")
        public List<StoredSessionAttemptWithSession> getAttemptsOfWorkflow(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="workflowName") String var3, @Bind(value="limit") int var4, @Bind(value="lastId") long var5, @Define(value="acFilter") String var7);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.id = sa.session_id join projects proj on proj.id = sa.project_id where s.project_id = :projectId and s.workflow_name = :workflowName and sa.site_id = :siteId and s.last_attempt_id is not null and sa.id \\< :lastId and <acFilter> order by sa.id desc limit :limit")
        public List<StoredSessionAttemptWithSession> getAttemptsOfWorkflowWithRetries(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="workflowName") String var3, @Bind(value="limit") int var4, @Bind(value="lastId") long var5, @Define(value="acFilter") String var7);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.last_attempt_id = sa.id where s.project_id = :projectId and s.workflow_name = :workflowName and sa.state_flags = 0 and sa.site_id = :siteId and sa.id \\< :lastId order by sa.id desc limit :limit")
        public List<StoredSessionAttemptWithSession> getActiveAttemptsOfWorkflow(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="workflowName") String var3, @Bind(value="limit") int var4, @Bind(value="lastId") long var5);

        @SqlQuery(value="select * from session_attempts where session_id = :sessionId and site_id = :siteId and id \\< :lastId order by id desc limit :limit")
        public List<StoredSessionAttempt> getAttemptsOfSessionWithRetries(@Bind(value="siteId") int var1, @Bind(value="sessionId") long var2, @Bind(value="limit") int var4, @Bind(value="lastId") long var5);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.id = sa.session_id where sa.id = :id and sa.site_id = :siteId and s.last_attempt_id is not null")
        public StoredSessionAttemptWithSession getAttemptById(@Bind(value="siteId") int var1, @Bind(value="id") long var2);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.last_attempt_id = sa.id where s.project_id = :projectId and s.workflow_name = :workflowName and s.session_time = :sessionTime and sa.site_id = :siteId")
        public StoredSessionAttemptWithSession getLastAttemptByName(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="workflowName") String var3, @Bind(value="sessionTime") long var4);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.id = sa.session_id where s.project_id = :projectId and s.workflow_name = :workflowName and s.session_time = :sessionTime and sa.attempt_name = :attemptName and sa.site_id = :siteId limit 1")
        public StoredSessionAttemptWithSession getAttemptByName(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="workflowName") String var3, @Bind(value="sessionTime") long var4, @Bind(value="attemptName") String var6);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.id = sa.session_id where sa.session_id = (select session_id from session_attempts where id = :id and site_id = :siteId) and s.last_attempt_id is not null order by index")
        public List<StoredSessionAttemptWithSession> getOtherAttempts(@Bind(value="siteId") int var1, @Bind(value="id") long var2);

        @SqlQuery(value="select * from session_attempts sa where id = :id limit 1")
        public StoredSessionAttempt getAttemptByIdInternal(@Bind(value="id") long var1);

        @SqlQuery(value="select sa.* from session_attempts sa join sessions s on s.last_attempt_id = sa.id where s.id = :sessionId limit 1")
        public StoredSessionAttempt getLastAttemptInternal(@Bind(value="sessionId") long var1);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa join sessions s on s.id = sa.session_id where sa.id = :attemptId limit 1")
        public StoredSessionAttemptWithSession getAttemptWithSessionByIdInternal(@Bind(value="attemptId") long var1);

        @SqlQuery(value="select * from session_attempts where state_flags = 0 and created_at \\< :createdBefore and id \\> :lastId order by id asc limit :limit")
        public List<StoredSessionAttempt> findActiveAttemptsCreatedBefore(@Bind(value="createdBefore") Timestamp var1, @Bind(value="lastId") long var2, @Bind(value="limit") int var4);

        @SqlQuery(value="select site_id from tasks join session_attempts sa on sa.id = tasks.attempt_id where tasks.id = :taskId")
        public Integer getSiteIdOfTask(@Bind(value="taskId") long var1);

        @SqlQuery(value="select * from sessions where project_id = :projectId and workflow_name = :workflowName and session_time = :sessionTime limit 1")
        public StoredSession getSessionByConflictedNamesInternal(@Bind(value="projectId") int var1, @Bind(value="workflowName") String var2, @Bind(value="sessionTime") long var3);

        @SqlQuery(value="select session_time from sessions where project_id = :projectId and workflow_name = :workflowName and session_time \\< :beforeThisSessionTime order by session_time desc limit 1")
        public Long getLastExecutedSessionTime(@Bind(value="projectId") int var1, @Bind(value="workflowName") String var2, @Bind(value="beforeThisSessionTime") long var3);

        @SqlUpdate(value="insert into session_attempts (session_id, site_id, project_id, attempt_name, workflow_definition_id, state_flags, timezone, params, created_at, index) values (:sessionId, :siteId, :projectId, :attemptName, :workflowDefinitionId, :stateFlags, :timezone, :params, now(), (select coalesce(max(index), 0) + 1 from session_attempts where session_id = :sessionId))")
        @GetGeneratedKeys
        public long insertAttempt(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="sessionId") long var3, @Bind(value="attemptName") String var5, @Bind(value="workflowDefinitionId") Long var6, @Bind(value="stateFlags") int var7, @Bind(value="timezone") String var8, @Bind(value="params") Config var9);

        @SqlUpdate(value="insert into delayed_session_attempts (id, dependent_session_id, next_run_time, updated_at) values (:attemptId, :dependentSessionId, :nextRunTime, now())")
        public void insertDelayedAttempt(@Bind(value="attemptId") long var1, @Bind(value="dependentSessionId") Long var3, @Bind(value="nextRunTime") long var4);

        @SqlUpdate(value="update sessions set last_attempt_id = :attemptId, last_attempt_created_at = (select created_at from session_attempts where id = :attemptId) where id = :sessionId")
        public int updateLastAttemptId(@Bind(value="sessionId") long var1, @Bind(value="attemptId") long var3);

        @SqlQuery(value="select state from tasks t join sessoin_attempts a on t.attempt_id = s.id where a.site_id = :siteId and a.id = :id and t.parent_id is null limit 1")
        public Short getAttemptStateFlags(@Bind(value="siteId") int var1, @Bind(value="id") long var2);

        @SqlUpdate(value="insert into session_monitors (attempt_id, next_run_time, type, config, created_at, updated_at) values (:attemptId, :nextRunTime, :type, :config, now(), now())")
        @GetGeneratedKeys
        public long insertSessionMonitor(@Bind(value="attemptId") long var1, @Bind(value="nextRunTime") long var3, @Bind(value="type") String var5, @Bind(value="config") Config var6);

        @SqlQuery(value="select id from tasks where state = :state limit :limit")
        public List<Long> findAllTaskIdsByState(@Bind(value="state") short var1, @Bind(value="limit") int var2);

        public List<Long> findAllTaskIdsByStateAtRandom(@Bind(value="state") short var1, @Bind(value="limit") int var2);

        @SqlQuery(value="select id, session_id, state_flags, index from session_attempts where id = :attemptId for update")
        public SessionAttemptSummary lockAttempt(@Bind(value="attemptId") long var1);

        @SqlUpdate(value="insert into tasks (attempt_id, parent_id, task_type, state, state_flags, updated_at) values (:attemptId, :parentId, :taskType, :state, :stateFlags, now())")
        @GetGeneratedKeys
        public long insertTask(@Bind(value="attemptId") long var1, @Bind(value="parentId") Long var3, @Bind(value="taskType") int var4, @Bind(value="state") short var5, @Bind(value="stateFlags") int var6);

        @SqlUpdate(value="insert into task_details (id, full_name, local_config, export_config) values (:id, :fullName, :localConfig, :exportConfig)")
        public void insertTaskDetails(@Bind(value="id") long var1, @Bind(value="fullName") String var3, @Bind(value="localConfig") Config var4, @Bind(value="exportConfig") Config var5);

        @SqlUpdate(value="insert into task_state_details (id) values (:id)")
        public void insertEmptyTaskStateDetails(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into task_dependencies (upstream_id, downstream_id) values (:upstreamId, :downstreamId)")
        public void insertTaskDependency(@Bind(value="downstreamId") long var1, @Bind(value="upstreamId") long var3);

        @SqlUpdate(value="insert into tasks (attempt_id, parent_id, task_type, state, state_flags, updated_at) values (:attemptId, :parentId, :taskType, :state, :stateFlags, :updatedAt)")
        @GetGeneratedKeys
        public long insertResumedTask(@Bind(value="attemptId") long var1, @Bind(value="parentId") long var3, @Bind(value="taskType") int var5, @Bind(value="state") int var6, @Bind(value="stateFlags") int var7, @Bind(value="updatedAt") Timestamp var8);

        @SqlUpdate(value="insert into task_details (id, full_name, local_config, export_config, resuming_task_id) values (:id, :fullName, :localConfig, :exportConfig, :resumingTaskId)")
        public void insertResumedTaskDetails(@Bind(value="id") long var1, @Bind(value="fullName") String var3, @Bind(value="localConfig") Config var4, @Bind(value="exportConfig") Config var5, @Bind(value="resumingTaskId") long var6);

        @SqlUpdate(value="insert into task_state_details (id, subtask_config, export_params, store_params, report, error) values (:id, :subtaskConfig, :exportParams, :storeParams, :report, :error)")
        public void insertResumedTaskStateDetails(@Bind(value="id") long var1, @Bind(value="subtaskConfig") Config var3, @Bind(value="exportParams") Config var4, @Bind(value="storeParams") Config var5, @Bind(value="report") Config var6, @Bind(value="error") Config var7);

        @SqlUpdate(value="insert into resuming_tasks (attempt_id, source_task_id, full_name, updated_at, local_config, export_config, subtask_config, export_params, store_params, report, error, reset_store_params) values (:attemptId, :sourceTaskId, :fullName, :updatedAt, :localConfig, :exportConfig, :subtaskConfig, :exportParams, :storeParams, :report, :error, :reset_store_params)")
        @GetGeneratedKeys
        public long insertResumingTask(@Bind(value="attemptId") long var1, @Bind(value="sourceTaskId") long var3, @Bind(value="fullName") String var5, @Bind(value="updatedAt") Timestamp var6, @Bind(value="localConfig") Config var7, @Bind(value="exportConfig") Config var8, @Bind(value="subtaskConfig") Config var9, @Bind(value="exportParams") Config var10, @Bind(value="reset_store_params") String var11, @Bind(value="storeParams") Config var12, @Bind(value="report") Config var13, @Bind(value="error") Config var14);

        @SqlQuery(value="select * from resuming_tasks where attempt_id = :attemptId and full_name like :fullNamePattern")
        public List<ResumingTask> findResumingTasksByNamePrefix(@Bind(value="attemptId") long var1, @Bind(value="fullNamePattern") String var3);

        @SqlQuery(value="select id, attempt_id, parent_id, state, updated_at from tasks where updated_at \\> :updatedSince or (updated_at = :updatedSince and id > :lastId) order by updated_at asc, id asc limit :limit")
        public List<TaskStateSummary> findRecentlyChangedTasks(@Bind(value="updatedSince") Instant var1, @Bind(value="lastId") long var2, @Bind(value="limit") int var4);

        @SqlQuery(value="select id from tasks where state = :state and id \\> :lastId order by id asc limit :limit")
        public List<Long> findTasksByState(@Bind(value="state") short var1, @Bind(value="lastId") long var2, @Bind(value="limit") int var4);

        @SqlQuery(value="select id from tasks where id = :id for update")
        public Long lockTask(@Bind(value="id") long var1);

        public Long lockTaskIfNotLocked(@Bind(value="id") long var1);

        @SqlQuery(value="select id from tasks where attempt_id = :attemptId and parent_id is null for update")
        public Long lockRootTask(@Bind(value="attemptId") long var1);

        @SqlUpdate(value="update tasks set updated_at = now(), state = :newState where id = :id and state = :oldState")
        public long setState(@Bind(value="id") long var1, @Bind(value="oldState") short var3, @Bind(value="newState") short var4);

        @SqlUpdate(value="update tasks set started_at = coalesce(started_at, now()), updated_at = now(), state = :newState where id = :id and state = :oldState")
        public long setStartedState(@Bind(value="id") long var1, @Bind(value="oldState") short var3, @Bind(value="newState") short var4);

        @SqlUpdate(value="update tasks set updated_at = now(), state = :newState where id = :id and state = :oldState")
        public long setDoneState(@Bind(value="id") long var1, @Bind(value="oldState") short var3, @Bind(value="newState") short var4);

        @SqlUpdate(value="update task_state_details set error = :error where id = :id")
        public long setError(@Bind(value="id") long var1, @Bind(value="error") Config var3);

        @SqlUpdate(value="update task_state_details set subtask_config = :subtaskConfig, export_params = :exportParams, store_params = :storeParams, report = :report, error = null, reset_store_params = :resetStoreParams where id = :id")
        public long setSuccessfulReport(@Bind(value="id") long var1, @Bind(value="subtaskConfig") Config var3, @Bind(value="exportParams") Config var4, @Bind(value="resetStoreParams") String var5, @Bind(value="storeParams") Config var6, @Bind(value="report") Config var7);

        @SqlUpdate(value="update tasks set updated_at = now(), retry_at = NULL, state = 1 where state in (2,3) and retry_at \\<= now()")
        public int trySetRetryWaitingToReady();

        @SqlQuery(value="select * from session_monitors where next_run_time \\<= :currentTime limit :limit for update")
        public List<StoredSessionMonitor> lockReadySessionMonitors(@Bind(value="currentTime") long var1, @Bind(value="limit") int var3);

        @SqlUpdate(value="update session_monitors set next_run_time = :nextRunTime, updated_at = now() where id = :id")
        public void updateNextSessionMonitorRunTime(@Bind(value="id") long var1, @Bind(value="nextRunTime") long var3);

        @SqlUpdate(value="update delayed_session_attempts set next_run_time = :nextRunTime, updated_at = now() where id = :attemptId")
        public void updateNextDelayedAttemptRunTime(@Bind(value="attemptId") long var1, @Bind(value="nextRunTime") long var3);

        @SqlQuery(value="select tasks from task_archives ta join session_attempts sa on sa.id = ta.id where sa.id = :attemptId and sa.site_id = :siteId")
        public String getTaskArchiveById(@Bind(value="siteId") int var1, @Bind(value="attemptId") long var2);

        @SqlUpdate(value="insert into task_archives (id, tasks, created_at) values (:attemptId, :tasks, now())")
        public void insertTaskArchive(@Bind(value="attemptId") long var1, @Bind(value="tasks") String var3);

        @SqlUpdate(value="delete from session_monitors where id = :id")
        public void deleteSessionMonitor(@Bind(value="id") long var1);

        @SqlUpdate(value="delete from tasks where attempt_id = :attemptId")
        public int deleteTasks(@Bind(value="attemptId") long var1);

        @SqlUpdate(value="delete from task_details where id in (select id from tasks where attempt_id = :attemptId)")
        public void deleteTaskDetails(@Bind(value="attemptId") long var1);

        @SqlUpdate(value="delete from task_state_details where id in (select id from tasks where attempt_id = :attemptId)")
        public void deleteTaskStateDetails(@Bind(value="attemptId") long var1);

        @SqlUpdate(value="delete from task_dependencies where downstream_id in (select id from tasks where attempt_id = :attemptId)")
        public void deleteTaskDependencies(@Bind(value="attemptId") long var1);

        @SqlUpdate(value="delete from resuming_tasks where attempt_id = :attemptId")
        public int deleteResumingTasks(@Bind(value="attemptId") long var1);

        @SqlUpdate(value="delete from delayed_session_attempts where id = :attemptId")
        public void deleteDelayedAttempt(@Bind(value="attemptId") long var1);
    }

    @UseStringTemplate3StatementLocator
    public static interface PgDao
    extends Dao {
        @Override
        @SqlQuery(value="select s.*, sa.site_id, sa.attempt_name, sa.workflow_definition_id, sa.state_flags, sa.timezone, sa.params, sa.created_at, sa.finished_at, sa.index from sessions s join session_attempts sa on sa.id = s.last_attempt_id join projects proj on proj.id = s.project_id where s.project_id = any(array(select p.id from projects p where p.site_id = :siteId)) and s.id \\< :lastId and <acFilter> order by s.id desc limit :limit")
        public List<StoredSessionWithLastAttempt> getSessions(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") long var3, @Define(value="acFilter") String var5);

        @SqlQuery(value="insert into sessions (project_id, workflow_name, session_time) values (:projectId, :workflowName, :sessionTime) on conflict (project_id, workflow_name, session_time) do update set last_attempt_id = sessions.last_attempt_id returning *")
        public StoredSession upsertAndLockSession(@Bind(value="projectId") int var1, @Bind(value="workflowName") String var2, @Bind(value="sessionTime") long var3);

        @SqlQuery(value="select sa.*, s.session_uuid, s.workflow_name, s.session_time from session_attempts sa, sessions s where s.id = sa.session_id and sa.id = :attemptId limit 1 for update of s")
        public StoredSessionAttemptWithSession lockSessionByAttemptId(@Bind(value="attemptId") long var1);

        @Override
        @SqlQuery(value="select id from tasks where id = :id for update skip locked")
        public Long lockTaskIfNotLocked(@Bind(value="id") long var1);

        @Override
        @SqlQuery(value="select id from tasks where state = :state order by random() limit :limit")
        public List<Long> findAllTaskIdsByStateAtRandom(@Bind(value="state") short var1, @Bind(value="limit") int var2);
    }

    @UseStringTemplate3StatementLocator
    public static interface H2Dao
    extends Dao {
        @Override
        @SqlQuery(value="select s.*, sa.site_id, sa.attempt_name, sa.workflow_definition_id, sa.state_flags, sa.timezone, sa.params, sa.created_at, sa.finished_at, sa.index from sessions s join session_attempts sa on sa.id = s.last_attempt_id join projects proj on proj.id = s.project_id where s.project_id in (select p.id from projects p where p.site_id = :siteId) and s.id \\< :lastId and <acFilter> order by s.id desc limit :limit")
        public List<StoredSessionWithLastAttempt> getSessions(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") long var3, @Define(value="acFilter") String var5);

        @SqlUpdate(value="merge into sessions (project_id, workflow_name, session_time) key (project_id, workflow_name, session_time) values (:projectId, :workflowName, :sessionTime)")
        public void upsertAndLockSession(@Bind(value="projectId") int var1, @Bind(value="workflowName") String var2, @Bind(value="sessionTime") long var3);

        @SqlQuery(value="select id from sessions s where id = (select session_id from session_attempts where id = :attemptId) for update")
        public long lockSessionByAttemptId(@Bind(value="attemptId") long var1);

        @Override
        @SqlQuery(value="select id from tasks where id = :id for update")
        public Long lockTaskIfNotLocked(@Bind(value="id") long var1);

        @Override
        @SqlQuery(value="select id from tasks where state = :state order by random() limit :limit")
        public List<Long> findAllTaskIdsByStateAtRandom(@Bind(value="state") short var1, @Bind(value="limit") int var2);
    }

    private class DatabaseDelayedAttemptControlStore
    implements DelayedAttemptControlStore {
        private final Handle handle;
        private final Dao dao;

        public DatabaseDelayedAttemptControlStore(Handle handle) {
            this.handle = handle;
            this.dao = (Dao)handle.attach(DatabaseSessionStoreManager.dao(DatabaseSessionStoreManager.this.databaseType));
        }

        @Override
        @DigdagTimed(value="ddacst_", category="db", appendMethodName=true)
        public <T> T lockSessionOfAttempt(long attemptId, DelayedAttemptControlStore.DelayedSessionLockAction<T> func) throws ResourceConflictException, ResourceNotFoundException, ResourceLimitExceededException {
            StoredSessionAttemptWithSession attempt;
            if (this.dao instanceof H2Dao) {
                ((H2Dao)this.dao).lockSessionByAttemptId(attemptId);
                attempt = this.dao.getAttemptWithSessionByIdInternal(attemptId);
            } else {
                attempt = ((PgDao)this.dao).lockSessionByAttemptId(attemptId);
            }
            return func.call(new DatabaseSessionControlStore(this.handle, 0), attempt);
        }

        @Override
        @DigdagTimed(value="ddacst_", category="db", appendMethodName=true)
        public void delayDelayedAttempt(long attemptId, Instant nextRunTime) {
            this.dao.updateNextDelayedAttemptRunTime(attemptId, nextRunTime.getEpochSecond());
        }

        @Override
        @DigdagTimed(value="ddacst_", category="db", appendMethodName=true)
        public void completeDelayedAttempt(long attemptId) {
            this.dao.deleteDelayedAttempt(attemptId);
        }
    }

    private class DatabaseSessionControlStore
    implements SessionControlStore,
    SessionTransaction {
        private final Handle handle;
        private final int siteId;
        private final Dao dao;

        public DatabaseSessionControlStore(Handle handle, int siteId) {
            this.handle = handle;
            this.siteId = siteId;
            this.dao = (Dao)handle.attach(DatabaseSessionStoreManager.dao(DatabaseSessionStoreManager.this.databaseType));
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public StoredSessionAttempt insertAttempt(long sessionId, int projId, SessionAttempt attempt) throws ResourceConflictException, ResourceNotFoundException {
            long attemptId = DatabaseSessionStoreManager.this.catchForeignKeyNotFound(() -> DatabaseSessionStoreManager.this.catchConflict(() -> this.dao.insertAttempt(this.siteId, projId, sessionId, (String)attempt.getRetryAttemptName().or((Object)DatabaseSessionStoreManager.DEFAULT_ATTEMPT_NAME), (Long)attempt.getWorkflowDefinitionId().orNull(), AttemptStateFlags.empty().get(), attempt.getTimeZone().getId(), attempt.getParams()), "session attempt name=%s in session id=%d", attempt.getRetryAttemptName().or((Object)DatabaseSessionStoreManager.DEFAULT_ATTEMPT_NAME), sessionId), "workflow definition id=%d", attempt.getWorkflowDefinitionId().orNull());
            this.dao.updateLastAttemptId(sessionId, attemptId);
            try {
                return DatabaseSessionStoreManager.this.requiredResource(this.dao.getAttemptByIdInternal(attemptId), "attempt id=%d", attemptId);
            }
            catch (ResourceNotFoundException ex) {
                throw new IllegalStateException("Database state error", ex);
            }
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public StoredSessionAttempt insertDelayedAttempt(long sessionId, int projId, SessionAttempt attempt, Optional<Long> dependentSessionId) throws ResourceConflictException, ResourceNotFoundException {
            StoredSessionAttempt stored = this.insertAttempt(sessionId, projId, attempt);
            this.dao.insertDelayedAttempt(stored.getId(), (Long)dependentSessionId.orNull(), Instant.now().getEpochSecond());
            return stored;
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public long getActiveAttemptCount() {
            return (Long)((Query)this.handle.createQuery("select count(*) from session_attempts where site_id = :siteId and " + DatabaseSessionStoreManager.this.bitAnd("state_flags", Integer.toString(2)) + " = 0").bind("siteId", this.siteId)).mapTo(Long.TYPE).first();
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public Optional<Instant> getLastExecutedSessionTime(int projectId, String workflowName, Instant beforeThisSessionTime) {
            Long lastExecutedSessionTime = this.dao.getLastExecutedSessionTime(projectId, workflowName, beforeThisSessionTime.getEpochSecond());
            return Optional.fromNullable((Object)lastExecutedSessionTime).transform(seconds -> Instant.ofEpochSecond(seconds));
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public StoredSessionAttempt getLastAttempt(long sessionId) throws ResourceNotFoundException {
            return DatabaseSessionStoreManager.this.requiredResource(this.dao.getLastAttemptInternal(sessionId), "latest attempt of session id=%d", sessionId);
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public Optional<StoredSessionAttempt> getLastAttemptIfExists(long sessionId) {
            return Optional.fromNullable((Object)this.dao.getLastAttemptInternal(sessionId));
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public <T> T insertRootTask(long attemptId, Task task, SessionControlStore.SessionBuilderAction<T> func) {
            long taskId = this.dao.insertTask(attemptId, (Long)task.getParentId().orNull(), task.getTaskType().get(), task.getState().get(), task.getStateFlags().get());
            this.dao.insertTaskDetails(taskId, task.getFullName(), task.getConfig().getLocal(), task.getConfig().getExport());
            this.dao.insertEmptyTaskStateDetails(taskId);
            return func.call(new DatabaseTaskControlStore(this.handle), taskId);
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public void insertMonitors(long attemptId, List<SessionMonitor> monitors) {
            for (SessionMonitor monitor : monitors) {
                this.dao.insertSessionMonitor(attemptId, monitor.getNextRunTime().getEpochSecond(), monitor.getType(), monitor.getConfig());
            }
        }

        @Override
        @DigdagTimed(value="dscst_", category="db", appendMethodName=true)
        public <T> T putAndLockSession(Session session, SessionTransaction.SessionLockAction<T> func) throws ResourceConflictException, ResourceNotFoundException {
            StoredSession storedSession = this.dao.getSessionByConflictedNamesInternal(session.getProjectId(), session.getWorkflowName(), session.getSessionTime().getEpochSecond());
            if (storedSession == null) {
                if (this.dao instanceof H2Dao) {
                    DatabaseSessionStoreManager.this.catchForeignKeyNotFound(() -> {
                        ((H2Dao)this.dao).upsertAndLockSession(session.getProjectId(), session.getWorkflowName(), session.getSessionTime().getEpochSecond());
                        return 0;
                    }, "project id=%d", session.getProjectId());
                    storedSession = this.dao.getSessionByConflictedNamesInternal(session.getProjectId(), session.getWorkflowName(), session.getSessionTime().getEpochSecond());
                    if (storedSession == null) {
                        throw new IllegalStateException(String.format(Locale.ENGLISH, "Database state error: locked session is null: project_id=%d, workflow_name=%s, session_time=%d", session.getProjectId(), session.getWorkflowName(), session.getSessionTime().getEpochSecond()));
                    }
                } else {
                    storedSession = DatabaseSessionStoreManager.this.catchForeignKeyNotFound(() -> ((PgDao)this.dao).upsertAndLockSession(session.getProjectId(), session.getWorkflowName(), session.getSessionTime().getEpochSecond()), "project id=%d", session.getProjectId());
                }
            }
            return func.call(this, storedSession);
        }
    }

    private class DatabaseSessionStore
    implements SessionStore {
        private final int siteId;

        public DatabaseSessionStore(int siteId) {
            this.siteId = siteId;
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public long getActiveAttemptCount() {
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> new DatabaseSessionControlStore(handle, this.siteId).getActiveAttemptCount());
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public Optional<Instant> getLastExecutedSessionTime(int projectId, String workflowName, Instant beforeThisSessionTime) {
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> new DatabaseSessionControlStore(handle, this.siteId).getLastExecutedSessionTime(projectId, workflowName, beforeThisSessionTime));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public <T> T sessionTransaction(SessionStore.SessionTransactionAction<T> func) throws Exception {
            return (T)DatabaseSessionStoreManager.this.transaction((handle, dao) -> func.call(new DatabaseSessionControlStore(handle, this.siteId)), Exception.class);
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public <T> T putAndLockSession(Session session, SessionTransaction.SessionLockAction<T> func) throws ResourceConflictException, ResourceNotFoundException {
            return (T)DatabaseSessionStoreManager.this.transaction((handle, dao) -> {
                DatabaseSessionControlStore tran = new DatabaseSessionControlStore(handle, this.siteId);
                return tran.putAndLockSession(session, func);
            }, ResourceConflictException.class, ResourceNotFoundException.class);
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionWithLastAttempt> getSessions(int pageSize, Optional<Long> lastId, AccessController.ListFilter acFilter) {
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getSessions(this.siteId, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), acFilter.getSql()));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public StoredSessionWithLastAttempt getSessionById(long sessionId) throws ResourceNotFoundException {
            return DatabaseSessionStoreManager.this.requiredResource((handle, dao) -> dao.getSession(this.siteId, sessionId), "session id=%d", new Object[]{sessionId});
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionWithLastAttempt> getSessionsOfWorkflowByName(int projectId, String workflowName, int pageSize, Optional<Long> lastId, AccessController.ListFilter acFilter) {
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getSessionsOfWorkflowByName(this.siteId, projectId, workflowName, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), acFilter.getSql()));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionAttemptWithSession> getAttempts(boolean withRetriedAttempts, int pageSize, Optional<Long> lastId, AccessController.ListFilter filter) {
            if (withRetriedAttempts) {
                return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getAttemptsWithRetries(this.siteId, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), filter.getSql()));
            }
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getAttempts(this.siteId, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), filter.getSql()));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionAttemptWithSession> getAttemptsOfProject(boolean withRetriedAttempts, int projectId, int pageSize, Optional<Long> lastId, AccessController.ListFilter filter) {
            if (withRetriedAttempts) {
                return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getAttemptsOfProjectWithRetries(this.siteId, projectId, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), filter.getSql()));
            }
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getAttemptsOfProject(this.siteId, projectId, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), filter.getSql()));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionWithLastAttempt> getSessionsOfProject(int projectId, int pageSize, Optional<Long> lastId, AccessController.ListFilter acFilter) {
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getSessionsOfProject(this.siteId, projectId, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), acFilter.getSql()));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionAttemptWithSession> getAttemptsOfWorkflow(boolean withRetriedAttempts, int projectId, String workflowName, int pageSize, Optional<Long> lastId, AccessController.ListFilter filter) {
            if (withRetriedAttempts) {
                return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getAttemptsOfWorkflowWithRetries(this.siteId, projectId, workflowName, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), filter.getSql()));
            }
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getAttemptsOfWorkflow(this.siteId, projectId, workflowName, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE), filter.getSql()));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionAttemptWithSession> getActiveAttemptsOfWorkflow(int projectId, String workflowName, int pageSize, Optional<Long> lastId) {
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getActiveAttemptsOfWorkflow(this.siteId, projectId, workflowName, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE)));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionAttempt> getAttemptsOfSession(long sessionId, int pageSize, Optional<Long> lastId) {
            return DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getAttemptsOfSessionWithRetries(this.siteId, sessionId, pageSize, (Long)lastId.or((Object)Long.MAX_VALUE)));
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public StoredSessionAttemptWithSession getAttemptById(long attemptId) throws ResourceNotFoundException {
            return DatabaseSessionStoreManager.this.requiredResource((handle, dao) -> dao.getAttemptById(this.siteId, attemptId), "session attempt id=%d", new Object[]{attemptId});
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public StoredSessionAttemptWithSession getLastAttemptByName(int projectId, String workflowName, Instant sessionTime) throws ResourceNotFoundException {
            return DatabaseSessionStoreManager.this.requiredResource((handle, dao) -> dao.getLastAttemptByName(this.siteId, projectId, workflowName, sessionTime.getEpochSecond()), "session time=%s in project id=%d workflow name=%s", new Object[]{sessionTime, projectId, workflowName});
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public StoredSessionAttemptWithSession getAttemptByName(int projectId, String workflowName, Instant sessionTime, String retryAttemptName) throws ResourceNotFoundException {
            return DatabaseSessionStoreManager.this.requiredResource((handle, dao) -> dao.getAttemptByName(this.siteId, projectId, workflowName, sessionTime.getEpochSecond(), retryAttemptName), "session attempt name=%s in session project id=%d workflow name=%s time=%s", new Object[]{retryAttemptName, projectId, workflowName, sessionTime});
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<StoredSessionAttemptWithSession> getOtherAttempts(long attemptId) throws ResourceNotFoundException {
            return DatabaseSessionStoreManager.this.requiredResource((handle, dao) -> dao.getOtherAttempts(this.siteId, attemptId), "session attempt id=%d", new Object[]{attemptId});
        }

        @Override
        @DigdagTimed(value="dsst_", category="db", appendMethodName=true)
        public List<ArchivedTask> getTasksOfAttempt(long attemptId) {
            String archive;
            List tasks = DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> ((Query)((Query)handle.createQuery("select t.*, td.full_name, td.local_config, td.export_config, td.resuming_task_id, ts.subtask_config, ts.export_params, ts.store_params, ts.error, ts.report, ts.reset_store_params, (select " + DatabaseSessionStoreManager.this.commaGroupConcat("upstream_id") + " from task_dependencies where downstream_id = t.id) as upstream_ids from tasks t join session_attempts sa on sa.id = t.attempt_id join task_details td on t.id = td.id join task_state_details ts on t.id = ts.id where sa.site_id = :siteId and t.attempt_id = :attemptId order by t.id").bind("siteId", this.siteId)).bind("attemptId", attemptId)).map((ResultSetMapper)DatabaseSessionStoreManager.this.atm).list());
            if (tasks.isEmpty() && (archive = DatabaseSessionStoreManager.this.autoCommit((handle, dao) -> dao.getTaskArchiveById(this.siteId, attemptId))) != null) {
                return DatabaseSessionStoreManager.this.loadTaskArchive(archive);
            }
            return tasks;
        }
    }

    private class DatabaseTaskControlStore
    implements TaskControlStore {
        private final Handle handle;
        private final Dao dao;

        public DatabaseTaskControlStore(Handle handle) {
            this.handle = handle;
            this.dao = (Dao)handle.attach(Dao.class);
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public long getTaskCountOfAttempt(long attemptId) {
            long count = (Long)((Query)this.handle.createQuery("select count(*) from tasks t where t.attempt_id = :attemptId").bind("attemptId", attemptId)).mapTo(Long.TYPE).first();
            return count;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public long addSubtask(long attemptId, Task task) {
            long taskId = this.dao.insertTask(attemptId, (Long)task.getParentId().orNull(), task.getTaskType().get(), task.getState().get(), task.getStateFlags().get());
            this.dao.insertTaskDetails(taskId, task.getFullName(), task.getConfig().getLocal(), task.getConfig().getExport());
            this.dao.insertEmptyTaskStateDetails(taskId);
            return taskId;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public long addResumedSubtask(long attemptId, long parentId, TaskType taskType, TaskStateCode state, TaskStateFlags flags, ResumingTask resumingTask) {
            long taskId = this.dao.insertResumedTask(attemptId, parentId, taskType.get(), state.get(), flags.get(), DatabaseSessionStoreManager.sqlTimestampOf(resumingTask.getUpdatedAt()));
            this.dao.insertResumedTaskDetails(taskId, resumingTask.getFullName(), resumingTask.getConfig().getLocal(), resumingTask.getConfig().getExport(), resumingTask.getSourceTaskId());
            this.dao.insertResumedTaskStateDetails(taskId, resumingTask.getSubtaskConfig(), resumingTask.getExportParams(), resumingTask.getStoreParams(), null, resumingTask.getError());
            return taskId;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public void addResumingTasks(long attemptId, List<ResumingTask> tasks) {
            for (ResumingTask task : tasks) {
                this.dao.insertResumingTask(attemptId, task.getSourceTaskId(), task.getFullName(), DatabaseSessionStoreManager.sqlTimestampOf(task.getUpdatedAt()), task.getConfig().getLocal(), task.getConfig().getExport(), task.getSubtaskConfig(), task.getExportParams(), DatabaseSessionStoreManager.this.cklm.toBinding(task.getResetStoreParams()), task.getStoreParams(), DatabaseSessionStoreManager.taskReportToConfig(DatabaseSessionStoreManager.this.cf, task.getReport()), task.getError());
            }
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public List<ResumingTask> getResumingTasksByNamePrefix(long attemptId, String fullNamePrefix) {
            return this.dao.findResumingTasksByNamePrefix(attemptId, fullNamePrefix + '%');
        }

        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        @VisibleForTesting
        public Predicate<StoredTask> funcFilterGeneratedSubtasks(Optional<String> parentFullName) {
            Predicate<StoredTask> filterGeneratedSubtasks = s -> {
                if (!parentFullName.isPresent()) {
                    return true;
                }
                String pfname = (String)parentFullName.get();
                String chfname = s.getFullName();
                int pfnameLen = pfname.length();
                return !chfname.startsWith(pfname) || !chfname.substring(pfnameLen).contains("^sub");
            };
            return filterGeneratedSubtasks;
        }

        @Override
        public boolean copyInitialTasksForRetry(List<Long> recursiveChildrenIdList, Optional<String> parentFullName) {
            List tasks = this.handle.createQuery(DatabaseSessionStoreManager.this.selectTaskDetailsQuery() + " where t.id " + DatabaseSessionStoreManager.this.inLargeIdListExpression(recursiveChildrenIdList) + " and " + DatabaseSessionStoreManager.this.bitAnd("t.state_flags", Integer.toString(8)) + " != 0 order by t.id asc").map((ResultSetMapper)DatabaseSessionStoreManager.this.stm).list().stream().filter(this.funcFilterGeneratedSubtasks(parentFullName)).collect(Collectors.toList());
            if (tasks.isEmpty()) {
                return false;
            }
            DatabaseTaskControlStore store = new DatabaseTaskControlStore(this.handle);
            HashMap<Long, Long> oldIdToNewId = new HashMap<Long, Long>();
            for (StoredTask task : tasks) {
                ImmutableTask newTask = Task.taskBuilder().from(task).parentId((Optional<Long>)task.getParentId().transform(it -> oldIdToNewId.getOrDefault(it, (Long)it))).state(TaskStateCode.BLOCKED).stateFlags(TaskStateFlags.empty()).build();
                long newTaskId = this.addSubtask(((StoredTask)tasks.get(0)).getAttemptId(), newTask);
                oldIdToNewId.put(task.getId(), newTaskId);
                for (long oldUpstreamId : task.getUpstreams()) {
                    this.dao.insertTaskDependency(newTaskId, (Long)oldIdToNewId.get(oldUpstreamId));
                }
            }
            return true;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public void addDependencies(long downstream, List<Long> upstreams) {
            for (long upstream : upstreams) {
                this.dao.insertTaskDependency(downstream, upstream);
            }
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean isAnyProgressibleChild(long taskId) {
            return ((Query)this.handle.createQuery("select id from tasks where parent_id = :parentId and (state in (" + Stream.of(TaskStateCode.progressingStates()).map(it -> Short.toString(it.get())).collect(Collectors.joining(", ")) + ") or (state = " + 0 + " and not exists (select * from tasks up join task_dependencies dep on up.id = dep.upstream_id where dep.downstream_id = tasks.id and up.state not in (" + Stream.of(TaskStateCode.canRunDownstreamStates()).map(it -> Short.toString(it.get())).collect(Collectors.joining(", ")) + ")))) limit 1").bind("parentId", taskId)).mapTo(Long.class).first() != null;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean isAnyErrorChild(long taskId) {
            return ((Query)this.handle.createQuery("select parent_id from tasks where id in (select max(t.id) from tasks t join task_details td on t.id = td.id where parent_id = :parentId group by td.full_name) and (state = " + TaskStateCode.ERROR.get() + " or state = " + TaskStateCode.GROUP_ERROR.get() + ") limit 1").bind("parentId", taskId)).mapTo(Long.class).first() != null;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public List<Config> collectChildrenErrors(long taskId) {
            return ((Query)this.handle.createQuery("select ts.error from tasks t join task_state_details ts on t.id = ts.id where parent_id = :parentId and error is not null").bind("parentId", taskId)).map((ResultSetMapper)new ConfigResultSetMapper(DatabaseSessionStoreManager.this.configMapper, "error")).list();
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setState(long taskId, TaskStateCode beforeState, TaskStateCode afterState) {
            long n = this.dao.setState(taskId, beforeState.get(), afterState.get());
            return n > 0L;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setStartedState(long taskId, TaskStateCode beforeState, TaskStateCode afterState) {
            long n = this.dao.setStartedState(taskId, beforeState.get(), afterState.get());
            return n > 0L;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setDoneState(long taskId, TaskStateCode beforeState, TaskStateCode afterState) {
            long n = this.dao.setDoneState(taskId, beforeState.get(), afterState.get());
            return n > 0L;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setErrorStateShortCircuit(long taskId, TaskStateCode beforeState, TaskStateCode afterState, Config error) {
            long n = this.dao.setDoneState(taskId, beforeState.get(), afterState.get());
            if (n > 0L) {
                this.dao.setError(taskId, error);
                return true;
            }
            return false;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setPlannedStateSuccessful(long taskId, TaskStateCode beforeState, TaskStateCode afterState, TaskResult result) {
            long n = this.dao.setState(taskId, beforeState.get(), afterState.get());
            if (n > 0L) {
                this.dao.setSuccessfulReport(taskId, result.getSubtaskConfig(), result.getExportParams(), DatabaseSessionStoreManager.this.cklm.toBinding(result.getResetStoreParams()), result.getStoreParams(), DatabaseSessionStoreManager.this.cf.create());
                return true;
            }
            return false;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setSuccessStateShortCircuit(long taskId, TaskStateCode beforeState, TaskStateCode afterState, TaskResult result) {
            long n = this.dao.setState(taskId, beforeState.get(), afterState.get());
            if (n > 0L) {
                this.dao.setSuccessfulReport(taskId, result.getSubtaskConfig(), result.getExportParams(), DatabaseSessionStoreManager.this.cklm.toBinding(result.getResetStoreParams()), result.getStoreParams(), DatabaseSessionStoreManager.this.cf.create());
                return true;
            }
            return false;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setPlannedStateWithDelayedError(long taskId, TaskStateCode beforeState, TaskStateCode afterState, int newFlags, Optional<Config> updateError) {
            int n = ((Update)((Update)((Update)this.handle.createStatement("update tasks set updated_at = now(), state = :newState, state_flags = " + DatabaseSessionStoreManager.this.bitOr("state_flags", Integer.toString(newFlags)) + " where id = :id and state = :oldState").bind("id", taskId)).bind("oldState", beforeState.get())).bind("newState", afterState.get())).execute();
            if (n > 0) {
                if (updateError.isPresent()) {
                    this.dao.setError(taskId, (Config)updateError.get());
                }
                return true;
            }
            return false;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public boolean setRetryWaitingState(long taskId, TaskStateCode beforeState, TaskStateCode afterState, int retryInterval, Config stateParams, Optional<Config> updateError) {
            int n = ((Update)((Update)((Update)((Update)this.handle.createStatement("update tasks set updated_at = now(), state = :newState, state_params = :stateParams, retry_at = " + DatabaseSessionStoreManager.this.addSeconds("now()", retryInterval) + ", retry_count = retry_count + 1 where id = :id and state = :oldState").bind("id", taskId)).bind("oldState", beforeState.get())).bind("newState", afterState.get())).bind("stateParams", DatabaseSessionStoreManager.this.configMapper.toBinding(stateParams))).execute();
            if (n > 0) {
                if (updateError.isPresent()) {
                    this.dao.setError(taskId, (Config)updateError.get());
                }
                return true;
            }
            return false;
        }

        @Override
        @DigdagTimed(value="dtcst_", category="db", appendMethodName=true)
        public int trySetChildrenBlockedToReadyOrShortCircuitPlannedOrCanceled(long taskId) {
            return ((Update)this.handle.createStatement("update tasks set updated_at = now(), state = case when task_type = 1 then 5 when " + DatabaseSessionStoreManager.this.bitAnd("state_flags", Integer.toString(1)) + " != 0 then " + 9 + " else " + 1 + " end where state = " + 0 + " and parent_id = :parentId and exists (select * from tasks pt where pt.id = tasks.parent_id and pt.state in (" + Stream.of(TaskStateCode.canRunChildrenStates()).map(it -> Short.toString(it.get())).collect(Collectors.joining(", ")) + ") ) and not exists (select * from tasks up join task_dependencies dep on up.id = dep.upstream_id where dep.downstream_id = tasks.id and up.state not in (" + Stream.of(TaskStateCode.canRunDownstreamStates()).map(it -> Short.toString(it.get())).collect(Collectors.joining(", ")) + "))").bind("parentId", taskId)).execute();
        }
    }

    private class DatabaseSessionAttemptControlStore
    implements SessionAttemptControlStore {
        private final Handle handle;
        private final Dao dao;

        public DatabaseSessionAttemptControlStore(Handle handle) {
            this.handle = handle;
            this.dao = (Dao)handle.attach(DatabaseSessionStoreManager.dao(DatabaseSessionStoreManager.this.databaseType));
        }

        @Override
        public int aggregateAndInsertTaskArchive(long attemptId) {
            List tasks = ((Query)this.handle.createQuery("select t.*, td.full_name, td.local_config, td.export_config, td.resuming_task_id, ts.subtask_config, ts.export_params, ts.store_params, ts.error, ts.report, ts.reset_store_params, (select " + DatabaseSessionStoreManager.this.commaGroupConcat("upstream_id") + " from task_dependencies where downstream_id = t.id) as upstream_ids from tasks t join session_attempts sa on sa.id = t.attempt_id join task_details td on t.id = td.id join task_state_details ts on t.id = ts.id where t.attempt_id = :attemptId order by t.id").bind("attemptId", attemptId)).map((ResultSetMapper)DatabaseSessionStoreManager.this.atm).list();
            String archive = DatabaseSessionStoreManager.this.dumpTaskArchive(tasks);
            int count = tasks.size();
            this.dao.insertTaskArchive(attemptId, archive);
            return count;
        }

        @Override
        public <T> T lockRootTask(long attemptId, SessionStoreManager.TaskLockActionWithDetails<T> func) throws ResourceNotFoundException {
            long taskId = DatabaseSessionStoreManager.this.requiredResource(this.dao.lockRootTask(attemptId), "root task of attempt id=%d", attemptId);
            StoredTask task = DatabaseSessionStoreManager.this.getTaskById(this.handle, taskId);
            T result = func.call(new DatabaseTaskControlStore(this.handle), task);
            return result;
        }

        @Override
        public int deleteAllTasksOfAttempt(long attemptId) {
            this.dao.deleteTaskDependencies(attemptId);
            this.dao.deleteTaskStateDetails(attemptId);
            this.dao.deleteTaskDetails(attemptId);
            this.dao.deleteResumingTasks(attemptId);
            return this.dao.deleteTasks(attemptId);
        }

        @Override
        public boolean setDoneToAttemptState(long attemptId, boolean success) {
            int n;
            int code = 2;
            if (success) {
                code |= 4;
            }
            return (n = ((Update)this.handle.createStatement("update session_attempts set state_flags = " + DatabaseSessionStoreManager.this.bitOr("state_flags", Integer.toString(code)) + ", finished_at = now() where id = :attemptId").bind("attemptId", attemptId)).execute()) > 0;
        }
    }
}

