/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.inject.Inject;
import io.digdag.core.crypto.SecretCrypto;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.DatabaseSecretStore;
import io.digdag.core.database.TransactionManager;
import io.digdag.spi.SecretStore;
import io.digdag.spi.SecretStoreManager;

public class DatabaseSecretStoreManager
implements SecretStoreManager {
    private final DatabaseConfig config;
    private final TransactionManager tm;
    private final ConfigMapper cfm;
    private final SecretCrypto crypto;

    @Inject
    public DatabaseSecretStoreManager(DatabaseConfig config, TransactionManager tm, ConfigMapper cfm, SecretCrypto crypto) {
        this.config = config;
        this.tm = tm;
        this.cfm = cfm;
        this.crypto = crypto;
    }

    public SecretStore getSecretStore(int siteId) {
        return new DatabaseSecretStore(this.config, this.tm, this.cfm, siteId, this.crypto);
    }
}

