/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.commons.ThrowablesUtil;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

class ConfigMapper {
    private final ObjectMapper jsonTreeMapper = new ObjectMapper();
    private final ConfigFactory cf;

    @Inject
    public ConfigMapper(ConfigFactory cf) {
        this.cf = cf;
    }

    public ConfigArgumentFactory getArgumentFactory() {
        return new ConfigArgumentFactory();
    }

    public Optional<Config> fromResultSet(ResultSet rs, String column) throws SQLException {
        String text = rs.getString(column);
        if (rs.wasNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)this.fromText(text));
    }

    public Config fromResultSetOrEmpty(ResultSet rs, String column) throws SQLException {
        String text = rs.getString(column);
        if (rs.wasNull()) {
            return this.cf.create();
        }
        return this.fromText(text);
    }

    private Config fromText(String text) {
        try {
            JsonNode node = this.jsonTreeMapper.readTree(text);
            Preconditions.checkState((boolean)(node instanceof ObjectNode), (Object)"Stored Config must be an object");
            return this.cf.create((Object)((ObjectNode)node));
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    public String toText(Config config) {
        try {
            return this.jsonTreeMapper.writeValueAsString((Object)config);
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    public String toBinding(Config config) {
        if (config == null) {
            return null;
        }
        String text = this.toText(config);
        if ("{}".equals(text)) {
            return null;
        }
        return text;
    }

    public class ConfigArgument
    implements Argument {
        private final Config config;

        public ConfigArgument(Config config) {
            this.config = config;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            String text = ConfigMapper.this.toBinding(this.config);
            if (text == null) {
                statement.setNull(position, 2005);
            } else {
                statement.setString(position, text);
            }
        }

        public String toString() {
            return String.valueOf(this.config);
        }
    }

    public class ConfigArgumentFactory
    implements ArgumentFactory<Config> {
        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof Config;
        }

        public Argument build(Class<?> expectedType, Config value, StatementContext ctx) {
            return new ConfigArgument(value);
        }
    }
}

