/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.config;

import io.digdag.core.config.DuplicateKeyYAMLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

class StrictSafeConstructor
extends SafeConstructor {
    StrictSafeConstructor() {
        this.yamlConstructors.put(Tag.MAP, new StrictConstructYamlMap());
    }

    private class StrictConstructYamlMap
    extends SafeConstructor.ConstructYamlMap {
        private StrictConstructYamlMap() {
            super((SafeConstructor)StrictSafeConstructor.this);
        }

        public Object construct(Node node) {
            if (node instanceof MappingNode) {
                this.validateKeys((MappingNode)node);
            }
            return super.construct(node);
        }

        public void construct2ndStep(Node node, Object object) {
            if (node instanceof MappingNode) {
                this.validateKeys((MappingNode)node);
            }
            super.construct2ndStep(node, object);
        }

        private void validateKeys(MappingNode node) {
            Map<String, Long> keyCounts = node.getValue().stream().map(NodeTuple::getKeyNode).filter(n -> n instanceof ScalarNode).map(ScalarNode.class::cast).filter(n -> !"!include".equals(n.getTag().getValue())).collect(Collectors.groupingBy(ScalarNode::getValue, Collectors.counting()));
            List<String> duplicatedKeys = keyCounts.entrySet().stream().filter(it -> (Long)it.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
            if (!duplicatedKeys.isEmpty()) {
                throw new DuplicateKeyYAMLException(duplicatedKeys);
            }
        }
    }
}

