/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.archive;

import io.digdag.core.archive.ProjectArchive;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public interface WorkflowResourceMatcher {
    public boolean matches(String var1, Path var2);

    public static WorkflowResourceMatcher ofSingleFile(Path projectPath, Path workflowFilePath) {
        String exactResourceName = ProjectArchive.realPathToResourceName(projectPath.normalize().toAbsolutePath(), workflowFilePath.normalize().toAbsolutePath());
        return (resourceName, absolutePath) -> resourceName.equals(exactResourceName);
    }

    public static WorkflowResourceMatcher defaultMatcher() {
        return (resourceName, absolutePath) -> resourceName.endsWith(".dig") && !resourceName.contains("/") && Files.isRegularFile(absolutePath, new LinkOption[0]);
    }
}

