/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.core.agent.AgentId;
import io.digdag.core.log.TaskLogger;
import io.digdag.core.repository.ResourceLimitExceededException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.workflow.SessionAttemptConflictException;
import io.digdag.spi.OperatorContext;
import io.digdag.spi.StorageObject;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.TaskResult;
import java.io.IOException;
import java.time.Instant;
import java.util.List;

public interface TaskCallbackApi {
    public TaskLogger newTaskLogger(TaskRequest var1);

    public void taskHeartbeat(int var1, List<TaskRequest> var2, AgentId var3, int var4);

    public Optional<StorageObject> openArchive(TaskRequest var1) throws IOException;

    public void taskSucceeded(TaskRequest var1, AgentId var2, TaskResult var3);

    public void taskFailed(TaskRequest var1, AgentId var2, Config var3);

    public void retryTask(TaskRequest var1, AgentId var2, int var3, Config var4, Optional<Config> var5);

    public StoredSessionAttempt startSession(OperatorContext var1, int var2, ProjectIdentifier var3, String var4, Instant var5, Optional<String> var6, Config var7) throws ResourceNotFoundException, ResourceLimitExceededException, SessionAttemptConflictException;

    public static class ProjectIdentifier {
        private Optional<Integer> projectId = Optional.absent();
        private Optional<String> projectName = Optional.absent();

        private ProjectIdentifier() {
        }

        private ProjectIdentifier(int projectId) {
            this.projectId = Optional.of((Object)projectId);
        }

        private ProjectIdentifier(String projectName) {
            this.projectName = Optional.of((Object)projectName);
        }

        public static ProjectIdentifier ofId(int projectId) {
            return new ProjectIdentifier(projectId);
        }

        public static ProjectIdentifier ofName(String projectName) {
            return new ProjectIdentifier(projectName);
        }

        public boolean byId() {
            return this.projectId.isPresent();
        }

        public boolean byName() {
            return this.projectName.isPresent();
        }

        public Integer getId() {
            return (Integer)this.projectId.get();
        }

        public String getName() {
            return (String)this.projectName.get();
        }

        public String toString() {
            if (this.projectId.isPresent()) {
                return "projectId: " + this.projectId.get();
            }
            return "projectName: " + (String)this.projectName.get();
        }
    }
}

