/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.core.agent.AgentId;
import io.digdag.core.agent.TaskServerApi;
import io.digdag.core.queue.TaskQueueServerManager;
import io.digdag.core.workflow.WorkflowExecutor;
import io.digdag.spi.TaskQueueClient;
import io.digdag.spi.TaskRequest;
import java.util.List;

public class InProcessTaskServerApi
implements TaskServerApi {
    private final TaskQueueClient directQueueClient;
    private final WorkflowExecutor workflowExecutor;

    @Inject
    public InProcessTaskServerApi(TaskQueueServerManager queueManager, WorkflowExecutor workflowExecutor) {
        this.directQueueClient = queueManager.getInProcessTaskQueueClient();
        this.workflowExecutor = workflowExecutor;
    }

    @Override
    public List<TaskRequest> lockSharedAgentTasks(int count, AgentId agentId, int lockSeconds, long maxSleepMillis) {
        List locks = this.directQueueClient.lockSharedAgentTasks(count, agentId.toString(), lockSeconds, maxSleepMillis);
        if (locks.isEmpty()) {
            return ImmutableList.of();
        }
        return this.workflowExecutor.getTaskRequests(locks);
    }

    @Override
    public void interruptLocalWait() {
        this.directQueueClient.interruptLocalWait();
    }
}

