/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.spi.SecretAccessContext;
import io.digdag.spi.SecretProvider;
import io.digdag.spi.SecretStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSecretProvider
implements SecretProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSecretProvider.class);
    private final SecretAccessContext context;
    private final Config mounts;
    private final SecretStore secretStore;

    DefaultSecretProvider(SecretAccessContext context, Config mounts, SecretStore secretStore) {
        this.context = context;
        this.mounts = mounts;
        this.secretStore = secretStore;
    }

    public Optional<String> getSecretOptional(String key) {
        String errorMessage = "Illegal key: '" + key + "'";
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)errorMessage);
        Preconditions.checkArgument((key.indexOf(42) == -1 ? 1 : 0) != 0, (Object)errorMessage);
        String remountedKey = this.remount(key);
        return this.fetchSecret(remountedKey);
    }

    private String remount(String key) {
        JsonNode node;
        List segments = Splitter.on((char)'.').splitToList((CharSequence)key);
        segments.forEach(segment -> Preconditions.checkArgument((!Strings.isNullOrEmpty((String)segment) ? 1 : 0) != 0));
        ObjectNode scope = this.mounts.getInternalObjectNode();
        int i = 0;
        while (true) {
            String segment2;
            if ((node = scope.get(segment2 = (String)segments.get(i))) == null) {
                return key;
            }
            if (!node.isObject()) break;
            if (++i >= segments.size()) {
                return key;
            }
            scope = node;
        }
        if (node.isTextual()) {
            List remainder = segments.subList(i + 1, segments.size());
            List base = Splitter.on((char)'.').splitToList((CharSequence)node.asText());
            String remounted = FluentIterable.from((Iterable)base).append(remainder).join(Joiner.on((char)'.'));
            return remounted;
        }
        if (node.isBoolean() && node.asBoolean()) {
            logger.warn("Granting access to secrets in '_secrets' is deprecated. All secrets are accessible by default.");
            return key;
        }
        throw new ConfigException("Illegal value in _secrets: " + node);
    }

    private Optional<String> fetchSecret(String key) {
        Optional projectSecret = this.secretStore.getSecret(this.context.projectId(), "project", key);
        if (projectSecret.isPresent()) {
            return projectSecret;
        }
        return this.secretStore.getSecret(this.context.projectId(), "project-default", key);
    }

    static interface OperatorSecretFilter {
        public boolean test(String var1, boolean var2);
    }
}

