/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import io.digdag.core.Limits;
import io.digdag.spi.OperatorContext;
import io.digdag.spi.PrivilegedVariables;
import io.digdag.spi.SecretProvider;
import io.digdag.spi.TaskRequest;
import java.nio.file.Path;
import java.util.Objects;

class DefaultOperatorContext
implements OperatorContext {
    private final Path projectPath;
    private final TaskRequest taskRequest;
    private final SecretProvider secretProvider;
    private final PrivilegedVariables privilegedVariables;
    private final long maxWorkflowTasks;

    DefaultOperatorContext(Path projectPath, TaskRequest taskRequest, SecretProvider secretProvider, PrivilegedVariables privilegedVariables, Limits limits) {
        this.projectPath = Objects.requireNonNull(projectPath, "projectPath");
        this.taskRequest = Objects.requireNonNull(taskRequest, "taskRequest");
        this.secretProvider = Objects.requireNonNull(secretProvider, "secretProvider");
        this.privilegedVariables = Objects.requireNonNull(privilegedVariables, "privilegedVariables");
        this.maxWorkflowTasks = limits.maxWorkflowTasks();
    }

    public Path getProjectPath() {
        return this.projectPath;
    }

    public TaskRequest getTaskRequest() {
        return this.taskRequest;
    }

    public SecretProvider getSecrets() {
        return this.secretProvider;
    }

    public PrivilegedVariables getPrivilegedVariables() {
        return this.privilegedVariables;
    }

    public long getMaxWorkflowTasks() {
        return this.maxWorkflowTasks;
    }
}

