/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core;

import io.digdag.client.config.Config;
import javax.inject.Inject;

public class Limits {
    private static final long MAX_WORKFLOW_TASKS = Long.valueOf(System.getProperty("io.digdag.limits.maxWorkflowTasks", "1000"));
    private static final long MAX_ATTEMPTS = Long.valueOf(System.getProperty("io.digdag.limits.maxAttempts", "100"));
    private final long numOfMaxWorkflowTasks;
    private final long numOfMaxAttempts;

    @Inject
    public Limits(Config systemConfig) {
        this.numOfMaxWorkflowTasks = (Long)systemConfig.get("executor.task_max_run", Long.TYPE, (Object)MAX_WORKFLOW_TASKS);
        this.numOfMaxAttempts = (Long)systemConfig.get("executor.attempt_max_run", Long.TYPE, (Object)MAX_ATTEMPTS);
    }

    public long maxWorkflowTasks() {
        return this.numOfMaxWorkflowTasks;
    }

    public long maxAttempts() {
        return this.numOfMaxAttempts;
    }
}

