/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.core.agent.EditDistance;
import io.digdag.core.repository.ModelValidator;
import io.digdag.core.session.TaskType;
import io.digdag.core.workflow.Workflow;
import io.digdag.core.workflow.WorkflowTask;
import io.digdag.core.workflow.WorkflowTaskList;
import io.digdag.util.ParallelControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class WorkflowCompiler {
    private static final Set<String> GROUPING_TASK_CONFIG_KEYS = new HashSet<String>((Collection<String>)ImmutableList.of((Object)"timezone", (Object)"schedule", (Object)"sla", (Object)"_parallel", (Object)"_background", (Object)"_after", (Object)"_error", (Object)"_check", (Object)"_retry", (Object)"_export", (Object)"_secrets"));

    public Workflow compile(String name, Config config) {
        return Workflow.builder().name(name).meta(config.getNestedOrGetEmpty("meta")).tasks(this.compileTasks("", "+" + name, config)).build();
    }

    public WorkflowTaskList compileTasks(String parentFullName, String name, Config config) {
        return new Context().compile(parentFullName, name, config);
    }

    private class Context {
        private List<TaskBuilder> tasks = new ArrayList<TaskBuilder>();

        private Context() {
        }

        public WorkflowTaskList compile(String parentFullName, String name, Config config) {
            try {
                ModelValidator validator = ModelValidator.builder();
                this.collect((Optional<TaskBuilder>)Optional.absent(), parentFullName, name, config, validator);
                WorkflowTaskList list = WorkflowTaskList.of(this.tasks.stream().map(tb -> tb.build()).collect(Collectors.toList()));
                validator.validate("workflow", list);
                return list;
            }
            catch (ConfigException ex) {
                throw ex;
            }
            catch (IllegalStateException ex) {
                throw new ConfigException((Throwable)ex);
            }
        }

        public TaskBuilder collect(Optional<TaskBuilder> parent, String parentFullName, String name, Config originalConfig, ModelValidator validator) {
            Config config = originalConfig.deepCopy();
            List subtaskConfigs = config.getKeys().stream().filter(key -> key.startsWith("+")).map(key -> Maps.immutableEntry((Object)key, (Object)config.getNestedOrderedOrGetEmpty(key))).collect(Collectors.toList());
            config.getKeys().stream().filter(key -> key.startsWith("+")).forEach(key -> config.remove(key));
            String fullName = parentFullName + name;
            if (((Boolean)config.get("_disable", Boolean.TYPE, (Object)false)).booleanValue()) {
                return this.addTask(parent, name, fullName, true, config.getFactory().create().set("_disable", (Object)true));
            }
            if (config.has("_type") || config.getKeys().stream().anyMatch(key -> key.endsWith(">"))) {
                if (!subtaskConfigs.isEmpty()) {
                    throw new ConfigException("A task can't have subtasks: " + config);
                }
                if (config.getKeys().stream().filter(key -> key.endsWith(">")).count() > 1L) {
                    throw new ConfigException("A task can't have more than one operator: " + config);
                }
                this.validateSpecialSubtasks(fullName, config);
                return this.addTask(parent, name, fullName, false, config);
            }
            TaskBuilder tb = this.addTask(parent, name, fullName, true, config);
            subtaskConfigs.stream().forEach(pair -> validator.checkRawTaskName("task name", (String)pair.getKey()));
            List unusedKeys = config.getKeys().stream().filter(key -> !GROUPING_TASK_CONFIG_KEYS.contains(key)).collect(Collectors.toList());
            if (!unusedKeys.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String unusedKey : unusedKeys) {
                    List<String> candidates = EditDistance.suggest(unusedKey, GROUPING_TASK_CONFIG_KEYS, 0.5);
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if (candidates.isEmpty()) {
                        sb.append(String.format(Locale.ENGLISH, "'%s'", unusedKey));
                        continue;
                    }
                    sb.append(String.format(Locale.ENGLISH, "'%s' (did you mean %s?)", unusedKey, candidates.toString()));
                }
                validator.check(fullName, config, unusedKeys.isEmpty(), "contains invalid keys: " + sb.toString());
            }
            List subtasks = subtaskConfigs.stream().map(pair -> this.collect((Optional<TaskBuilder>)Optional.of((Object)tb), fullName, (String)pair.getKey(), (Config)pair.getValue(), validator)).collect(Collectors.toList());
            ParallelControl pc = ParallelControl.of((Config)config);
            HashMap<String, TaskBuilder> names = new HashMap<String, TaskBuilder>();
            if (pc.isParallel()) {
                if (pc.getParallelLimit() > 0) {
                    int limit = pc.getParallelLimit();
                    ArrayList beforeList = new ArrayList();
                    for (List chunkedSubtasks : Lists.partition(subtasks, (int)limit)) {
                        for (TaskBuilder subtask : chunkedSubtasks) {
                            this.parseSubtaskWithParallel(names, subtask);
                            for (TaskBuilder before : beforeList) {
                                subtask.addUpstream(before);
                            }
                        }
                        beforeList.clear();
                        beforeList.addAll(chunkedSubtasks);
                    }
                } else {
                    for (TaskBuilder subtask : subtasks) {
                        this.parseSubtaskWithParallel(names, subtask);
                    }
                }
            } else {
                ArrayList<TaskBuilder> beforeList = new ArrayList<TaskBuilder>();
                for (TaskBuilder subtask : subtasks) {
                    if (subtask.getConfig().has("_after")) {
                        throw new ConfigException("Setting \"_after\" option is invalid if its parent task doesn't have \"_parallel: true\" option");
                    }
                    if (((Boolean)subtask.getConfig().get("_background", Boolean.TYPE, (Object)false)).booleanValue()) {
                        beforeList.add(subtask);
                    } else {
                        for (TaskBuilder before : beforeList) {
                            subtask.addUpstream(before);
                        }
                        beforeList.clear();
                        beforeList.add(subtask);
                    }
                    subtask.modifyConfig().remove("_background");
                }
            }
            this.validateSpecialSubtasks(fullName, config);
            return tb;
        }

        private void validateSpecialSubtasks(String fullName, Config config) {
            Config errorTask = config.getNestedOrGetEmpty("_error");
            if (!errorTask.isEmpty()) {
                WorkflowCompiler.this.compileTasks(fullName, "^error", errorTask);
            }
        }

        private TaskBuilder addTask(Optional<TaskBuilder> parent, String name, String fullName, boolean groupingOnly, Config config) {
            TaskBuilder tb = new TaskBuilder(this.tasks.size(), parent, name, fullName, this.extractTaskOption(config, groupingOnly), config);
            this.tasks.add(tb);
            return tb;
        }

        private TaskType extractTaskOption(Config config, boolean groupingOnly) {
            return new TaskType.Builder().groupingOnly(groupingOnly).build();
        }

        private void parseSubtaskWithParallel(Map<String, TaskBuilder> names, TaskBuilder subtask) {
            if (((Boolean)subtask.getConfig().get("_background", Boolean.TYPE, (Object)false)).booleanValue()) {
                throw new ConfigException("Setting \"_background: true\" option is invalid (unnecessary) if its parent task has \"_parallel: true\" option");
            }
            for (String upName : subtask.getConfig().getListOrEmpty("_after", String.class)) {
                TaskBuilder up = names.get(upName);
                if (up == null) {
                    throw new ConfigException("Dependency task '" + upName + "' does not exist");
                }
                subtask.addUpstream(up);
            }
            subtask.modifyConfig().remove("_after");
            names.put(subtask.getName(), subtask);
        }
    }

    private static class TaskBuilder {
        private final int index;
        private final Optional<TaskBuilder> parent;
        private final String name;
        private final String fullName;
        private final TaskType taskType;
        private Config config;
        private final List<TaskBuilder> children = new ArrayList<TaskBuilder>();
        private final List<TaskBuilder> upstreams = new ArrayList<TaskBuilder>();

        public TaskBuilder(int index, Optional<TaskBuilder> parent, String name, String fullName, TaskType taskType, Config config) {
            this.index = index;
            this.parent = parent;
            this.name = name;
            this.fullName = fullName;
            this.taskType = taskType;
            this.config = config;
            if (parent.isPresent()) {
                ((TaskBuilder)parent.get()).addChild(this);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Config getConfig() {
            return this.config;
        }

        public Config modifyConfig() {
            Config newConfig;
            this.config = newConfig = this.config.deepCopy();
            return newConfig;
        }

        private void addChild(TaskBuilder child) {
            this.children.add(child);
        }

        public void addUpstream(TaskBuilder up) {
            this.upstreams.add(up);
        }

        public WorkflowTask build() {
            return new WorkflowTask.Builder().name(this.name).fullName(this.fullName).index(this.index).parentIndex((Optional<Integer>)this.parent.transform(it -> it.index)).upstreamIndexes(this.upstreams.stream().map(it -> it.index).collect(Collectors.toList())).taskType(this.taskType).config(this.config).build();
        }
    }
}

