/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.session.TaskType;
import io.digdag.core.workflow.WorkflowTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableWorkflowTask
extends WorkflowTask {
    private final String name;
    private final String fullName;
    private final int index;
    private final Optional<Integer> parentIndex;
    private final ImmutableList<Integer> upstreamIndexes;
    private final TaskType taskType;
    private final Config config;

    private ImmutableWorkflowTask(String name, String fullName, int index, Optional<Integer> parentIndex, ImmutableList<Integer> upstreamIndexes, TaskType taskType, Config config) {
        this.name = name;
        this.fullName = fullName;
        this.index = index;
        this.parentIndex = parentIndex;
        this.upstreamIndexes = upstreamIndexes;
        this.taskType = taskType;
        this.config = config;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @JsonProperty(value="index")
    public int getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="parentIndex")
    public Optional<Integer> getParentIndex() {
        return this.parentIndex;
    }

    @JsonProperty(value="upstreamIndexes")
    public ImmutableList<Integer> getUpstreamIndexes() {
        return this.upstreamIndexes;
    }

    @Override
    @JsonProperty(value="taskType")
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    public final ImmutableWorkflowTask withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(newValue, this.fullName, this.index, this.parentIndex, this.upstreamIndexes, this.taskType, this.config));
    }

    public final ImmutableWorkflowTask withFullName(String value) {
        if (this.fullName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fullName");
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, newValue, this.index, this.parentIndex, this.upstreamIndexes, this.taskType, this.config));
    }

    public final ImmutableWorkflowTask withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, value, this.parentIndex, this.upstreamIndexes, this.taskType, this.config));
    }

    public final ImmutableWorkflowTask withParentIndex(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.parentIndex.equals((Object)newValue)) {
            return this;
        }
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, this.index, (Optional<Integer>)newValue, this.upstreamIndexes, this.taskType, this.config));
    }

    public final ImmutableWorkflowTask withParentIndex(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"parentIndex");
        if (this.parentIndex.equals((Object)value)) {
            return this;
        }
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, this.index, (Optional<Integer>)value, this.upstreamIndexes, this.taskType, this.config));
    }

    public final ImmutableWorkflowTask withUpstreamIndexes(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, this.index, this.parentIndex, (ImmutableList<Integer>)newValue, this.taskType, this.config));
    }

    public final ImmutableWorkflowTask withUpstreamIndexes(Iterable<Integer> elements) {
        if (this.upstreamIndexes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, this.index, this.parentIndex, (ImmutableList<Integer>)newValue, this.taskType, this.config));
    }

    public final ImmutableWorkflowTask withTaskType(TaskType value) {
        if (this.taskType == value) {
            return this;
        }
        TaskType newValue = (TaskType)Preconditions.checkNotNull((Object)value, (Object)"taskType");
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, this.index, this.parentIndex, this.upstreamIndexes, newValue, this.config));
    }

    public final ImmutableWorkflowTask withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, this.index, this.parentIndex, this.upstreamIndexes, this.taskType, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowTask && this.equalTo((ImmutableWorkflowTask)another);
    }

    private boolean equalTo(ImmutableWorkflowTask another) {
        return this.name.equals(another.name) && this.fullName.equals(another.fullName) && this.index == another.index && this.parentIndex.equals(another.parentIndex) && this.upstreamIndexes.equals(another.upstreamIndexes) && this.taskType.equals(another.taskType) && this.config.equals((Object)another.config);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.fullName.hashCode();
        h = h * 17 + this.index;
        h = h * 17 + this.parentIndex.hashCode();
        h = h * 17 + this.upstreamIndexes.hashCode();
        h = h * 17 + this.taskType.hashCode();
        h = h * 17 + this.config.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowTask").omitNullValues().add("name", (Object)this.name).add("fullName", (Object)this.fullName).add("index", this.index).add("parentIndex", this.parentIndex.orNull()).add("upstreamIndexes", this.upstreamIndexes).add("taskType", (Object)this.taskType).add("config", (Object)this.config).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflowTask fromJson(Json json) {
        WorkflowTask.Builder builder = new WorkflowTask.Builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.fullName != null) {
            builder.fullName(json.fullName);
        }
        if (json.indexIsSet) {
            builder.index(json.index);
        }
        if (json.parentIndex != null) {
            builder.parentIndex(json.parentIndex);
        }
        if (json.upstreamIndexes != null) {
            builder.addAllUpstreamIndexes(json.upstreamIndexes);
        }
        if (json.taskType != null) {
            builder.taskType(json.taskType);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        return builder.build();
    }

    private static ImmutableWorkflowTask validate(ImmutableWorkflowTask instance) {
        instance.check();
        return instance;
    }

    public static ImmutableWorkflowTask copyOf(WorkflowTask instance) {
        if (instance instanceof ImmutableWorkflowTask) {
            return (ImmutableWorkflowTask)instance;
        }
        return new WorkflowTask.Builder().from(instance).build();
    }

    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_FULL_NAME = 2L;
        private static final long INIT_BIT_INDEX = 4L;
        private static final long INIT_BIT_TASK_TYPE = 8L;
        private static final long INIT_BIT_CONFIG = 16L;
        private long initBits = 31L;
        @Nullable
        private String name;
        @Nullable
        private String fullName;
        private int index;
        private Optional<Integer> parentIndex = Optional.absent();
        private ImmutableList.Builder<Integer> upstreamIndexes = ImmutableList.builder();
        @Nullable
        private TaskType taskType;
        @Nullable
        private Config config;

        public Builder() {
            if (!(this instanceof WorkflowTask.Builder)) {
                throw new UnsupportedOperationException("Use: new WorkflowTask.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final WorkflowTask.Builder from(WorkflowTask instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.name(instance.getName());
            this.fullName(instance.getFullName());
            this.index(instance.getIndex());
            Optional<Integer> parentIndexOptional = instance.getParentIndex();
            if (parentIndexOptional.isPresent()) {
                this.parentIndex(parentIndexOptional);
            }
            this.addAllUpstreamIndexes(instance.getUpstreamIndexes());
            this.taskType(instance.getTaskType());
            this.config(instance.getConfig());
            return (WorkflowTask.Builder)this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final WorkflowTask.Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (WorkflowTask.Builder)this;
        }

        @JsonProperty(value="fullName")
        @CanIgnoreReturnValue
        public final WorkflowTask.Builder fullName(String fullName) {
            this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (Object)"fullName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (WorkflowTask.Builder)this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final WorkflowTask.Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (WorkflowTask.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WorkflowTask.Builder parentIndex(int parentIndex) {
            this.parentIndex = Optional.of((Object)parentIndex);
            return (WorkflowTask.Builder)this;
        }

        @JsonProperty(value="parentIndex")
        @CanIgnoreReturnValue
        public final WorkflowTask.Builder parentIndex(Optional<Integer> parentIndex) {
            this.parentIndex = (Optional)Preconditions.checkNotNull(parentIndex, (Object)"parentIndex");
            return (WorkflowTask.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WorkflowTask.Builder addUpstreamIndexes(int element) {
            this.upstreamIndexes.add((Object)element);
            return (WorkflowTask.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WorkflowTask.Builder addUpstreamIndexes(int ... elements) {
            this.upstreamIndexes.addAll((Iterable)Ints.asList((int[])elements));
            return (WorkflowTask.Builder)this;
        }

        @JsonProperty(value="upstreamIndexes")
        @CanIgnoreReturnValue
        public final WorkflowTask.Builder upstreamIndexes(Iterable<Integer> elements) {
            this.upstreamIndexes = ImmutableList.builder();
            return this.addAllUpstreamIndexes(elements);
        }

        @CanIgnoreReturnValue
        public final WorkflowTask.Builder addAllUpstreamIndexes(Iterable<Integer> elements) {
            this.upstreamIndexes.addAll(elements);
            return (WorkflowTask.Builder)this;
        }

        @JsonProperty(value="taskType")
        @CanIgnoreReturnValue
        public final WorkflowTask.Builder taskType(TaskType taskType) {
            this.taskType = (TaskType)Preconditions.checkNotNull((Object)taskType, (Object)"taskType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (WorkflowTask.Builder)this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final WorkflowTask.Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (WorkflowTask.Builder)this;
        }

        public ImmutableWorkflowTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableWorkflowTask.validate(new ImmutableWorkflowTask(this.name, this.fullName, this.index, this.parentIndex, this.upstreamIndexes.build(), this.taskType, this.config));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fullName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("taskType");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build WorkflowTask, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends WorkflowTask {
        @Nullable
        String name;
        @Nullable
        String fullName;
        int index;
        boolean indexIsSet;
        Optional<Integer> parentIndex = Optional.absent();
        List<Integer> upstreamIndexes = ImmutableList.of();
        @Nullable
        TaskType taskType;
        @Nullable
        Config config;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="fullName")
        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @JsonProperty(value="index")
        public void setIndex(int index) {
            this.index = index;
            this.indexIsSet = true;
        }

        @JsonProperty(value="parentIndex")
        public void setParentIndex(Optional<Integer> parentIndex) {
            this.parentIndex = parentIndex;
        }

        @JsonProperty(value="upstreamIndexes")
        public void setUpstreamIndexes(List<Integer> upstreamIndexes) {
            this.upstreamIndexes = upstreamIndexes;
        }

        @JsonProperty(value="taskType")
        public void setTaskType(TaskType taskType) {
            this.taskType = taskType;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFullName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getParentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> getUpstreamIndexes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskType getTaskType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }
    }
}

