/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ModelValidator;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.session.SessionMonitor;
import io.digdag.core.workflow.ImmutableAttemptRequest;
import io.digdag.core.workflow.ImmutableStored;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableAttemptRequest.class)
@JsonDeserialize(as=ImmutableAttemptRequest.class)
@Value.Immutable
public abstract class AttemptRequest {
    public abstract Stored getStored();

    public abstract String getWorkflowName();

    public abstract Instant getSessionTime();

    public abstract ZoneId getTimeZone();

    public abstract Config getSessionParams();

    public abstract List<SessionMonitor> getSessionMonitors();

    public abstract Optional<String> getRetryAttemptName();

    public abstract Optional<Long> getResumingAttemptId();

    public abstract List<Long> getResumingTasks();

    @Value.Check
    protected void check() {
        ModelValidator validator = ModelValidator.builder();
        if (this.getRetryAttemptName().isPresent()) {
            validator.checkIdentifierName("retry attempt name", (String)this.getRetryAttemptName().get());
        }
        if (!this.getResumingAttemptId().isPresent()) {
            validator.check("resuming attempt id list", this.getResumingTasks(), this.getResumingTasks().isEmpty(), "must be empty if resuming attempt id is not set");
        }
        validator.validate("attempt request", this);
    }

    @JsonSerialize(as=ImmutableStored.class)
    @JsonDeserialize(as=ImmutableStored.class)
    @Value.Immutable
    public static abstract class Stored {
        public abstract long getWorkflowDefinitionId();

        public abstract int getProjectId();

        public static Stored of(StoredRevision rev, StoredWorkflowDefinition def) {
            return ImmutableStored.builder().workflowDefinitionId(def.getId()).projectId(rev.getProjectId()).build();
        }

        public static Stored of(StoredWorkflowDefinitionWithProject def) {
            return ImmutableStored.builder().workflowDefinitionId(def.getId()).projectId(def.getProject().getId()).build();
        }
    }
}

