/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.digdag.core.session.ImmutableSession;
import io.digdag.core.session.ImmutableStoredSessionAttemptWithSession;
import io.digdag.core.session.Session;
import io.digdag.core.session.StoredSession;
import io.digdag.core.session.StoredSessionAttempt;
import java.util.UUID;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableStoredSessionAttemptWithSession.class)
@JsonDeserialize(as=ImmutableStoredSessionAttemptWithSession.class)
@Value.Immutable
public abstract class StoredSessionAttemptWithSession
extends StoredSessionAttempt {
    public abstract int getSiteId();

    public abstract UUID getSessionUuid();

    public abstract Session getSession();

    public static StoredSessionAttemptWithSession of(int siteId, StoredSession session, StoredSessionAttempt attempt) {
        return StoredSessionAttemptWithSession.of(siteId, session.getUuid(), ImmutableSession.builder().from(session).build(), attempt);
    }

    public static StoredSessionAttemptWithSession of(int siteId, UUID sessionUuid, Session session, StoredSessionAttempt attempt) {
        return ImmutableStoredSessionAttemptWithSession.builder().id(attempt.getId()).retryAttemptName(attempt.getRetryAttemptName()).workflowDefinitionId(attempt.getWorkflowDefinitionId()).timeZone(attempt.getTimeZone()).params(attempt.getParams()).stateFlags(attempt.getStateFlags()).sessionId(attempt.getSessionId()).index(attempt.getIndex()).createdAt(attempt.getCreatedAt()).siteId(siteId).sessionUuid(sessionUuid).session(session).build();
    }

    public static StoredSessionAttemptWithSession dryRunDummy(int siteId, Session session, StoredSessionAttempt attempt) {
        return StoredSessionAttemptWithSession.of(siteId, UUID.randomUUID(), session, attempt);
    }
}

