/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.session.AttemptStateFlags;
import io.digdag.core.session.DelayedAttemptControlStore;
import io.digdag.core.session.ParameterUpdate;
import io.digdag.core.session.SessionAttemptControlStore;
import io.digdag.core.session.SessionAttemptSummary;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.StoredDelayedSessionAttempt;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.core.session.StoredSessionMonitor;
import io.digdag.core.session.StoredTask;
import io.digdag.core.session.TaskAttemptSummary;
import io.digdag.core.session.TaskControlStore;
import io.digdag.core.session.TaskRelation;
import io.digdag.core.session.TaskStateCode;
import io.digdag.core.session.TaskStateSummary;
import java.time.Instant;
import java.util.List;

public interface SessionStoreManager {
    public SessionStore getSessionStore(int var1);

    public Instant getStoreTime();

    public int getSiteIdOfTask(long var1) throws ResourceNotFoundException;

    public StoredSessionAttemptWithSession getAttemptWithSessionById(long var1) throws ResourceNotFoundException;

    public AttemptStateFlags getAttemptStateFlags(long var1) throws ResourceNotFoundException;

    public boolean isAnyNotDoneAttempts();

    default public List<Long> findAllReadyTaskIds(int maxEntries) {
        return this.findAllReadyTaskIds(maxEntries, false);
    }

    public List<Long> findAllReadyTaskIds(int var1, boolean var2);

    public List<StoredSessionAttempt> findActiveAttemptsCreatedBefore(Instant var1, long var2, int var4);

    public List<TaskAttemptSummary> findTasksStartedBeforeWithState(TaskStateCode[] var1, Instant var2, long var3, int var5);

    public <T> Optional<T> lockAttemptIfExists(long var1, AttemptLockAction<T> var3);

    public List<TaskStateSummary> findRecentlyChangedTasks(Instant var1, long var2);

    public List<Long> findTasksByState(TaskStateCode var1, long var2);

    public List<TaskAttemptSummary> findRootTasksByStates(TaskStateCode[] var1, long var2);

    public List<Long> findDirectParentsOfBlockedTasks(long var1);

    public boolean requestCancelAttempt(long var1);

    public int trySetRetryWaitingToReady();

    public <T> Optional<T> lockTaskIfExists(long var1, TaskLockAction<T> var3);

    public <T> Optional<T> lockTaskIfNotLocked(long var1, TaskLockAction<T> var3);

    public <T> Optional<T> lockTaskIfExists(long var1, TaskLockActionWithDetails<T> var3);

    public <T> Optional<T> lockTaskIfNotLocked(long var1, TaskLockActionWithDetails<T> var3);

    public void lockReadySessionMonitors(Instant var1, SessionMonitorAction var2);

    public List<TaskRelation> getTaskRelations(long var1);

    public List<Config> getExportParams(List<Long> var1);

    public List<ParameterUpdate> getStoreParams(List<Long> var1);

    public List<Config> getErrors(List<Long> var1);

    public void lockReadyDelayedAttempts(Instant var1, DelayedAttemptAction var2);

    public static interface DelayedAttemptAction {
        public void submit(DelayedAttemptControlStore var1, StoredDelayedSessionAttempt var2);
    }

    public static interface SessionMonitorAction {
        public Optional<Instant> schedule(StoredSessionMonitor var1);
    }

    public static interface TaskLockActionWithDetails<T> {
        public T call(TaskControlStore var1, StoredTask var2);
    }

    public static interface TaskLockAction<T> {
        public T call(TaskControlStore var1);
    }

    public static interface AttemptLockAction<T> {
        public T call(SessionAttemptControlStore var1, SessionAttemptSummary var2);
    }
}

