/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.session.SessionAttempt;
import io.digdag.core.session.SessionAttemptImpl;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableSessionAttempt
extends SessionAttemptImpl {
    private final Optional<String> retryAttemptName;
    private final Optional<Long> workflowDefinitionId;
    private final ZoneId timeZone;
    private final Config params;

    private ImmutableSessionAttempt(Optional<String> retryAttemptName, Optional<Long> workflowDefinitionId, ZoneId timeZone, Config params) {
        this.retryAttemptName = retryAttemptName;
        this.workflowDefinitionId = workflowDefinitionId;
        this.timeZone = timeZone;
        this.params = params;
    }

    @Override
    @JsonProperty(value="retryAttemptName")
    public Optional<String> getRetryAttemptName() {
        return this.retryAttemptName;
    }

    @Override
    @JsonProperty(value="workflowDefinitionId")
    public Optional<Long> getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @Override
    @JsonProperty(value="timeZone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @JsonProperty(value="params")
    public Config getParams() {
        return this.params;
    }

    public final ImmutableSessionAttempt withRetryAttemptName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAttemptName.equals((Object)newValue)) {
            return this;
        }
        return ImmutableSessionAttempt.validate(new ImmutableSessionAttempt((Optional<String>)newValue, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableSessionAttempt withRetryAttemptName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAttemptName");
        if (this.retryAttemptName.equals((Object)value)) {
            return this;
        }
        return ImmutableSessionAttempt.validate(new ImmutableSessionAttempt((Optional<String>)value, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableSessionAttempt withWorkflowDefinitionId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.workflowDefinitionId.equals((Object)newValue)) {
            return this;
        }
        return ImmutableSessionAttempt.validate(new ImmutableSessionAttempt(this.retryAttemptName, (Optional<Long>)newValue, this.timeZone, this.params));
    }

    public final ImmutableSessionAttempt withWorkflowDefinitionId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"workflowDefinitionId");
        if (this.workflowDefinitionId.equals((Object)value)) {
            return this;
        }
        return ImmutableSessionAttempt.validate(new ImmutableSessionAttempt(this.retryAttemptName, (Optional<Long>)value, this.timeZone, this.params));
    }

    public final ImmutableSessionAttempt withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return ImmutableSessionAttempt.validate(new ImmutableSessionAttempt(this.retryAttemptName, this.workflowDefinitionId, newValue, this.params));
    }

    public final ImmutableSessionAttempt withParams(Config value) {
        if (this.params == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"params");
        return ImmutableSessionAttempt.validate(new ImmutableSessionAttempt(this.retryAttemptName, this.workflowDefinitionId, this.timeZone, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionAttempt && this.equalTo((ImmutableSessionAttempt)another);
    }

    private boolean equalTo(ImmutableSessionAttempt another) {
        return this.retryAttemptName.equals(another.retryAttemptName) && this.workflowDefinitionId.equals(another.workflowDefinitionId) && this.timeZone.equals(another.timeZone) && this.params.equals((Object)another.params);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.retryAttemptName.hashCode();
        h = h * 17 + this.workflowDefinitionId.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        h = h * 17 + this.params.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SessionAttempt").omitNullValues().add("retryAttemptName", this.retryAttemptName.orNull()).add("workflowDefinitionId", this.workflowDefinitionId.orNull()).add("timeZone", (Object)this.timeZone).add("params", (Object)this.params).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSessionAttempt fromJson(Json json) {
        Builder builder = ImmutableSessionAttempt.builder();
        if (json.retryAttemptName != null) {
            builder.retryAttemptName(json.retryAttemptName);
        }
        if (json.workflowDefinitionId != null) {
            builder.workflowDefinitionId(json.workflowDefinitionId);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        if (json.params != null) {
            builder.params(json.params);
        }
        return builder.build();
    }

    private static ImmutableSessionAttempt validate(ImmutableSessionAttempt instance) {
        instance.check();
        return instance;
    }

    public static ImmutableSessionAttempt copyOf(SessionAttemptImpl instance) {
        if (instance instanceof ImmutableSessionAttempt) {
            return (ImmutableSessionAttempt)instance;
        }
        return ImmutableSessionAttempt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIME_ZONE = 1L;
        private static final long INIT_BIT_PARAMS = 2L;
        private long initBits = 3L;
        private Optional<String> retryAttemptName = Optional.absent();
        private Optional<Long> workflowDefinitionId = Optional.absent();
        @Nullable
        private ZoneId timeZone;
        @Nullable
        private Config params;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionAttempt instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionAttemptImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof SessionAttempt) {
                Optional<String> retryAttemptNameOptional;
                SessionAttempt instance = (SessionAttempt)object;
                this.timeZone(instance.getTimeZone());
                Optional<Long> workflowDefinitionIdOptional = instance.getWorkflowDefinitionId();
                if (workflowDefinitionIdOptional.isPresent()) {
                    this.workflowDefinitionId(workflowDefinitionIdOptional);
                }
                if ((retryAttemptNameOptional = instance.getRetryAttemptName()).isPresent()) {
                    this.retryAttemptName(retryAttemptNameOptional);
                }
                this.params(instance.getParams());
            }
        }

        @CanIgnoreReturnValue
        public final Builder retryAttemptName(String retryAttemptName) {
            this.retryAttemptName = Optional.of((Object)retryAttemptName);
            return this;
        }

        @JsonProperty(value="retryAttemptName")
        @CanIgnoreReturnValue
        public final Builder retryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = (Optional)Preconditions.checkNotNull(retryAttemptName, (Object)"retryAttemptName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = Optional.of((Object)workflowDefinitionId);
            return this;
        }

        @JsonProperty(value="workflowDefinitionId")
        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = (Optional)Preconditions.checkNotNull(workflowDefinitionId, (Object)"workflowDefinitionId");
            return this;
        }

        @JsonProperty(value="timeZone")
        @CanIgnoreReturnValue
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="params")
        @CanIgnoreReturnValue
        public final Builder params(Config params) {
            this.params = (Config)Preconditions.checkNotNull((Object)params, (Object)"params");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSessionAttempt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSessionAttempt.validate(new ImmutableSessionAttempt(this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timeZone");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("params");
            }
            return "Cannot build SessionAttempt, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends SessionAttemptImpl {
        Optional<String> retryAttemptName = Optional.absent();
        Optional<Long> workflowDefinitionId = Optional.absent();
        @Nullable
        ZoneId timeZone;
        @Nullable
        Config params;

        Json() {
        }

        @JsonProperty(value="retryAttemptName")
        public void setRetryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = retryAttemptName;
        }

        @JsonProperty(value="workflowDefinitionId")
        public void setWorkflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @JsonProperty(value="params")
        public void setParams(Config params) {
            this.params = params;
        }

        @Override
        public Optional<String> getRetryAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getWorkflowDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getParams() {
            throw new UnsupportedOperationException();
        }
    }
}

