/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.schedule;

import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.schedule.ScheduleControlStore;
import io.digdag.core.schedule.StoredSchedule;
import io.digdag.spi.ScheduleTime;
import java.time.Instant;

public class ScheduleControl {
    private final ScheduleControlStore store;
    private StoredSchedule schedule;

    public ScheduleControl(ScheduleControlStore store, StoredSchedule schedule) {
        this.store = store;
        this.schedule = schedule;
    }

    public StoredSchedule get() {
        return this.schedule;
    }

    public void updateNextScheduleTime(ScheduleTime nextTime) throws ResourceNotFoundException {
        this.store.updateNextScheduleTime(this.schedule.getId(), nextTime);
    }

    public void updateNextScheduleTimeAndLastSessionTime(ScheduleTime nextTime, Instant lastSessionTime) throws ResourceNotFoundException {
        this.store.updateNextScheduleTimeAndLastSessionTime(this.schedule.getId(), nextTime, lastSessionTime);
    }

    public void enableSchedule() {
        this.store.enableSchedule(this.schedule.getId());
        this.schedule = this.store.getScheduleById(this.schedule.getId());
    }

    public void disableSchedule() {
        this.store.disableSchedule(this.schedule.getId());
        this.schedule = this.store.getScheduleById(this.schedule.getId());
    }
}

