/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.schedule;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.schedule.ScheduleStatus;
import io.digdag.spi.ScheduleTime;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableScheduleStatus
implements ScheduleStatus {
    private final ScheduleTime nextScheduleTime;
    private final Optional<Instant> lastScheduleTime;

    private ImmutableScheduleStatus(ScheduleTime nextScheduleTime, Optional<Instant> lastScheduleTime) {
        this.nextScheduleTime = nextScheduleTime;
        this.lastScheduleTime = lastScheduleTime;
    }

    @Override
    @JsonProperty(value="nextScheduleTime")
    public ScheduleTime getNextScheduleTime() {
        return this.nextScheduleTime;
    }

    @Override
    @JsonProperty(value="lastScheduleTime")
    public Optional<Instant> getLastScheduleTime() {
        return this.lastScheduleTime;
    }

    public final ImmutableScheduleStatus withNextScheduleTime(ScheduleTime value) {
        if (this.nextScheduleTime == value) {
            return this;
        }
        ScheduleTime newValue = (ScheduleTime)Preconditions.checkNotNull((Object)value, (Object)"nextScheduleTime");
        return new ImmutableScheduleStatus(newValue, this.lastScheduleTime);
    }

    public final ImmutableScheduleStatus withLastScheduleTime(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.lastScheduleTime.isPresent() && this.lastScheduleTime.get() == value) {
            return this;
        }
        return new ImmutableScheduleStatus(this.nextScheduleTime, (Optional<Instant>)newValue);
    }

    public final ImmutableScheduleStatus withLastScheduleTime(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"lastScheduleTime");
        if (!this.lastScheduleTime.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.lastScheduleTime.isPresent() && value.isPresent() && this.lastScheduleTime.get() == value.get()) {
            return this;
        }
        return new ImmutableScheduleStatus(this.nextScheduleTime, (Optional<Instant>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScheduleStatus && this.equalTo((ImmutableScheduleStatus)another);
    }

    private boolean equalTo(ImmutableScheduleStatus another) {
        return this.nextScheduleTime.equals(another.nextScheduleTime) && this.lastScheduleTime.equals(another.lastScheduleTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.nextScheduleTime.hashCode();
        h = h * 17 + this.lastScheduleTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ScheduleStatus").omitNullValues().add("nextScheduleTime", (Object)this.nextScheduleTime).add("lastScheduleTime", this.lastScheduleTime.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScheduleStatus fromJson(Json json) {
        Builder builder = ImmutableScheduleStatus.builder();
        if (json.nextScheduleTime != null) {
            builder.nextScheduleTime(json.nextScheduleTime);
        }
        if (json.lastScheduleTime != null) {
            builder.lastScheduleTime(json.lastScheduleTime);
        }
        return builder.build();
    }

    public static ImmutableScheduleStatus copyOf(ScheduleStatus instance) {
        if (instance instanceof ImmutableScheduleStatus) {
            return (ImmutableScheduleStatus)instance;
        }
        return ImmutableScheduleStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NEXT_SCHEDULE_TIME = 1L;
        private long initBits = 1L;
        @Nullable
        private ScheduleTime nextScheduleTime;
        private Optional<Instant> lastScheduleTime = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScheduleStatus instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.nextScheduleTime(instance.getNextScheduleTime());
            Optional<Instant> lastScheduleTimeOptional = instance.getLastScheduleTime();
            if (lastScheduleTimeOptional.isPresent()) {
                this.lastScheduleTime(lastScheduleTimeOptional);
            }
            return this;
        }

        @JsonProperty(value="nextScheduleTime")
        @CanIgnoreReturnValue
        public final Builder nextScheduleTime(ScheduleTime nextScheduleTime) {
            this.nextScheduleTime = (ScheduleTime)Preconditions.checkNotNull((Object)nextScheduleTime, (Object)"nextScheduleTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastScheduleTime(Instant lastScheduleTime) {
            this.lastScheduleTime = Optional.of((Object)lastScheduleTime);
            return this;
        }

        @JsonProperty(value="lastScheduleTime")
        @CanIgnoreReturnValue
        public final Builder lastScheduleTime(Optional<Instant> lastScheduleTime) {
            this.lastScheduleTime = (Optional)Preconditions.checkNotNull(lastScheduleTime, (Object)"lastScheduleTime");
            return this;
        }

        public ImmutableScheduleStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScheduleStatus(this.nextScheduleTime, this.lastScheduleTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nextScheduleTime");
            }
            return "Cannot build ScheduleStatus, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ScheduleStatus {
        @Nullable
        ScheduleTime nextScheduleTime;
        Optional<Instant> lastScheduleTime = Optional.absent();

        Json() {
        }

        @JsonProperty(value="nextScheduleTime")
        public void setNextScheduleTime(ScheduleTime nextScheduleTime) {
            this.nextScheduleTime = nextScheduleTime;
        }

        @JsonProperty(value="lastScheduleTime")
        public void setLastScheduleTime(Optional<Instant> lastScheduleTime) {
            this.lastScheduleTime = lastScheduleTime;
        }

        @Override
        public ScheduleTime getNextScheduleTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getLastScheduleTime() {
            throw new UnsupportedOperationException();
        }
    }
}

