/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.schedule;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.schedule.ScheduleConfig;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableScheduleConfig
implements ScheduleConfig {
    private final boolean enabled;

    private ImmutableScheduleConfig(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean getEnabled() {
        return this.enabled;
    }

    public final ImmutableScheduleConfig withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableScheduleConfig(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScheduleConfig && this.equalTo((ImmutableScheduleConfig)another);
    }

    private boolean equalTo(ImmutableScheduleConfig another) {
        return this.enabled == another.enabled;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode((boolean)this.enabled);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ScheduleConfig").omitNullValues().add("enabled", this.enabled).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScheduleConfig fromJson(Json json) {
        Builder builder = ImmutableScheduleConfig.builder();
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        return builder.build();
    }

    public static ImmutableScheduleConfig copyOf(ScheduleConfig instance) {
        if (instance instanceof ImmutableScheduleConfig) {
            return (ImmutableScheduleConfig)instance;
        }
        return ImmutableScheduleConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private long initBits = 1L;
        private boolean enabled;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScheduleConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.enabled(instance.getEnabled());
            return this;
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableScheduleConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScheduleConfig(this.enabled);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build ScheduleConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ScheduleConfig {
        boolean enabled;
        boolean enabledIsSet;

        Json() {
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @Override
        public boolean getEnabled() {
            throw new UnsupportedOperationException();
        }
    }
}

