/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ImmutableWorkflowDefinition;
import io.digdag.core.repository.ModelValidator;
import java.time.ZoneId;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableWorkflowDefinition.class)
public abstract class WorkflowDefinition {
    public abstract String getName();

    public abstract Config getConfig();

    public abstract ZoneId getTimeZone();

    public static WorkflowDefinition of(String name, Config config, ZoneId timeZone) {
        return ImmutableWorkflowDefinition.builder().name(name).config(config).timeZone(timeZone).build();
    }

    @Value.Check
    protected void check() {
        ModelValidator.builder().checkWorkflowName("name", this.getName()).validate("workflow", this);
    }
}

