/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.repository.ProjectControlStore;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.Revision;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.schedule.Schedule;
import io.digdag.core.schedule.SchedulerManager;
import io.digdag.spi.ScheduleTime;
import io.digdag.spi.Scheduler;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectControl {
    private final ProjectControlStore store;
    private final StoredProject project;

    public static <T> T deleteProject(ProjectStore rs, int projId, DeleteProjectAction<T> callback) throws ResourceNotFoundException {
        return (T)rs.deleteProject(projId, (store, proj) -> {
            ProjectControl control = new ProjectControl(store, proj);
            Object res = callback.call(control, proj);
            control.deleteSchedules();
            return res;
        });
    }

    public ProjectControl(ProjectControlStore store, StoredProject project) {
        this.store = store;
        this.project = project;
    }

    public StoredProject get() {
        return this.project;
    }

    public StoredRevision insertRevision(Revision revision) throws ResourceConflictException {
        return this.store.insertRevision(this.project.getId(), revision);
    }

    public void insertRevisionArchiveData(int revId, byte[] data) throws ResourceConflictException {
        this.store.insertRevisionArchiveData(revId, data);
    }

    public List<StoredWorkflowDefinition> insertWorkflowDefinitions(StoredRevision revision, List<WorkflowDefinition> defs, SchedulerManager srm, Instant currentTime) throws ResourceConflictException {
        List<StoredWorkflowDefinition> list = this.insertWorkflowDefinitionsWithoutSchedules(revision, defs);
        this.updateSchedules(revision, list, srm, currentTime);
        return list;
    }

    public List<StoredWorkflowDefinition> insertWorkflowDefinitionsWithoutSchedules(StoredRevision revision, List<WorkflowDefinition> defs) throws ResourceConflictException {
        try {
            return defs.stream().map(def -> {
                try {
                    return this.store.insertWorkflowDefinition(this.project.getId(), revision.getId(), (WorkflowDefinition)def, def.getTimeZone());
                }
                catch (ResourceConflictException ex) {
                    throw new IllegalStateException("Database state error", ex);
                }
            }).collect(Collectors.toList());
        }
        catch (IllegalStateException ex) {
            ThrowablesUtil.propagateIfInstanceOf((Throwable)ex.getCause(), ResourceConflictException.class);
            throw ex;
        }
    }

    private void updateSchedules(StoredRevision revision, List<StoredWorkflowDefinition> defs, SchedulerManager srm, Instant currentTime) throws ResourceConflictException {
        ImmutableList.Builder schedules = ImmutableList.builder();
        for (StoredWorkflowDefinition def : defs) {
            Optional<Scheduler> sr = srm.tryGetScheduler(revision, def, true);
            if (!sr.isPresent()) continue;
            ScheduleTime firstTime = ((Scheduler)sr.get()).getFirstScheduleTime(currentTime);
            Schedule schedule = Schedule.of(def.getName(), def.getId(), firstTime.getRunTime(), firstTime.getTime());
            schedules.add((Object)new ScheduleWithScheduler(schedule, (Scheduler)sr.get()));
        }
        this.store.updateSchedules(this.project.getId(), schedules.build(), (oldStatus, newSched) -> (ScheduleTime)oldStatus.getLastScheduleTime().transform(it -> newSched.getScheduler().nextScheduleTime(it)).or(() -> ScheduleTime.of((Instant)newSched.getNextScheduleTime(), (Instant)newSched.getNextRunTime())));
    }

    public void deleteSchedules() {
        this.store.deleteSchedules(this.project.getId());
    }

    private static class ScheduleWithScheduler
    extends Schedule {
        private Schedule schedule;
        private Scheduler scheduler;

        ScheduleWithScheduler(Schedule schedule, Scheduler scheduler) {
            this.schedule = schedule;
            this.scheduler = scheduler;
        }

        @Override
        public String getWorkflowName() {
            return this.schedule.getWorkflowName();
        }

        @Override
        public long getWorkflowDefinitionId() {
            return this.schedule.getWorkflowDefinitionId();
        }

        @Override
        public Instant getNextRunTime() {
            return this.schedule.getNextRunTime();
        }

        @Override
        public Instant getNextScheduleTime() {
            return this.schedule.getNextScheduleTime();
        }

        public Scheduler getScheduler() {
            return this.scheduler;
        }
    }

    public static interface DeleteProjectAction<T> {
        public T call(ProjectControl var1, StoredProject var2) throws ResourceNotFoundException;
    }
}

