/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ArchiveType;
import io.digdag.core.repository.Revision;
import io.digdag.core.repository.StoredRevision;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredRevision
extends StoredRevision {
    private final int id;
    private final int projectId;
    private final Instant createdAt;
    private final String name;
    private final Config defaultParams;
    private final ArchiveType archiveType;
    private final Optional<byte[]> archiveMd5;
    private final Optional<String> archivePath;
    private final Config userInfo;

    private ImmutableStoredRevision(int id, int projectId, Instant createdAt, String name, Config defaultParams, ArchiveType archiveType, Optional<byte[]> archiveMd5, Optional<String> archivePath, Config userInfo) {
        this.id = id;
        this.projectId = projectId;
        this.createdAt = createdAt;
        this.name = name;
        this.defaultParams = defaultParams;
        this.archiveType = archiveType;
        this.archiveMd5 = archiveMd5;
        this.archivePath = archivePath;
        this.userInfo = userInfo;
    }

    @Override
    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="projectId")
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="defaultParams")
    public Config getDefaultParams() {
        return this.defaultParams;
    }

    @Override
    @JsonProperty(value="archiveType")
    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    @Override
    @JsonProperty(value="archiveMd5")
    public Optional<byte[]> getArchiveMd5() {
        return this.archiveMd5;
    }

    @Override
    @JsonProperty(value="archivePath")
    public Optional<String> getArchivePath() {
        return this.archivePath;
    }

    @Override
    @JsonProperty(value="userInfo")
    public Config getUserInfo() {
        return this.userInfo;
    }

    public final ImmutableStoredRevision withId(int value) {
        if (this.id == value) {
            return this;
        }
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(value, this.projectId, this.createdAt, this.name, this.defaultParams, this.archiveType, this.archiveMd5, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, value, this.createdAt, this.name, this.defaultParams, this.archiveType, this.archiveMd5, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, newValue, this.name, this.defaultParams, this.archiveType, this.archiveMd5, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, newValue, this.defaultParams, this.archiveType, this.archiveMd5, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withDefaultParams(Config value) {
        if (this.defaultParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"defaultParams");
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, newValue, this.archiveType, this.archiveMd5, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withArchiveType(ArchiveType value) {
        if (this.archiveType == value) {
            return this;
        }
        ArchiveType newValue = (ArchiveType)Preconditions.checkNotNull((Object)value, (Object)"archiveType");
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, this.defaultParams, newValue, this.archiveMd5, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withArchiveMd5(byte[] value) {
        Optional newValue = Optional.of((Object)value);
        if (this.archiveMd5.isPresent() && this.archiveMd5.get() == value) {
            return this;
        }
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, this.defaultParams, this.archiveType, (Optional<byte[]>)newValue, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withArchiveMd5(Optional<byte[]> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"archiveMd5");
        if (!this.archiveMd5.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.archiveMd5.isPresent() && value.isPresent() && this.archiveMd5.get() == value.get()) {
            return this;
        }
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, this.defaultParams, this.archiveType, (Optional<byte[]>)value, this.archivePath, this.userInfo));
    }

    public final ImmutableStoredRevision withArchivePath(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.archivePath.equals((Object)newValue)) {
            return this;
        }
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, this.defaultParams, this.archiveType, this.archiveMd5, (Optional<String>)newValue, this.userInfo));
    }

    public final ImmutableStoredRevision withArchivePath(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"archivePath");
        if (this.archivePath.equals((Object)value)) {
            return this;
        }
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, this.defaultParams, this.archiveType, this.archiveMd5, (Optional<String>)value, this.userInfo));
    }

    public final ImmutableStoredRevision withUserInfo(Config value) {
        if (this.userInfo == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"userInfo");
        return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, this.defaultParams, this.archiveType, this.archiveMd5, this.archivePath, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredRevision && this.equalTo((ImmutableStoredRevision)another);
    }

    private boolean equalTo(ImmutableStoredRevision another) {
        return this.id == another.id && this.projectId == another.projectId && this.createdAt.equals(another.createdAt) && this.name.equals(another.name) && this.defaultParams.equals((Object)another.defaultParams) && this.archiveType.equals(another.archiveType) && this.archiveMd5.equals(another.archiveMd5) && this.archivePath.equals(another.archivePath) && this.userInfo.equals((Object)another.userInfo);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id;
        h = h * 17 + this.projectId;
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.defaultParams.hashCode();
        h = h * 17 + this.archiveType.hashCode();
        h = h * 17 + this.archiveMd5.hashCode();
        h = h * 17 + this.archivePath.hashCode();
        h = h * 17 + this.userInfo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredRevision").omitNullValues().add("id", this.id).add("projectId", this.projectId).add("createdAt", (Object)this.createdAt).add("name", (Object)this.name).add("defaultParams", (Object)this.defaultParams).add("archiveType", (Object)this.archiveType).add("archiveMd5", this.archiveMd5.orNull()).add("archivePath", this.archivePath.orNull()).add("userInfo", (Object)this.userInfo).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredRevision fromJson(Json json) {
        Builder builder = ImmutableStoredRevision.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.defaultParams != null) {
            builder.defaultParams(json.defaultParams);
        }
        if (json.archiveType != null) {
            builder.archiveType(json.archiveType);
        }
        if (json.archiveMd5 != null) {
            builder.archiveMd5(json.archiveMd5);
        }
        if (json.archivePath != null) {
            builder.archivePath(json.archivePath);
        }
        if (json.userInfo != null) {
            builder.userInfo(json.userInfo);
        }
        return builder.build();
    }

    private static ImmutableStoredRevision validate(ImmutableStoredRevision instance) {
        instance.check();
        return instance;
    }

    public static ImmutableStoredRevision copyOf(StoredRevision instance) {
        if (instance instanceof ImmutableStoredRevision) {
            return (ImmutableStoredRevision)instance;
        }
        return ImmutableStoredRevision.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROJECT_ID = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_DEFAULT_PARAMS = 16L;
        private static final long INIT_BIT_ARCHIVE_TYPE = 32L;
        private static final long INIT_BIT_USER_INFO = 64L;
        private long initBits = 127L;
        private int id;
        private int projectId;
        @Nullable
        private Instant createdAt;
        @Nullable
        private String name;
        @Nullable
        private Config defaultParams;
        @Nullable
        private ArchiveType archiveType;
        private Optional<byte[]> archiveMd5 = Optional.absent();
        private Optional<String> archivePath = Optional.absent();
        @Nullable
        private Config userInfo;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredRevision instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Revision instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Revision instance;
            if (object instanceof StoredRevision) {
                instance = (StoredRevision)object;
                this.createdAt(((StoredRevision)instance).getCreatedAt());
                this.projectId(((StoredRevision)instance).getProjectId());
                this.id(((StoredRevision)instance).getId());
            }
            if (object instanceof Revision) {
                instance = (Revision)object;
                this.name(instance.getName());
                Optional<byte[]> archiveMd5Optional = instance.getArchiveMd5();
                if (archiveMd5Optional.isPresent()) {
                    this.archiveMd5(archiveMd5Optional);
                }
                this.userInfo(instance.getUserInfo());
                this.archiveType(instance.getArchiveType());
                Optional<String> archivePathOptional = instance.getArchivePath();
                if (archivePathOptional.isPresent()) {
                    this.archivePath(archivePathOptional);
                }
                this.defaultParams(instance.getDefaultParams());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="projectId")
        @CanIgnoreReturnValue
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="defaultParams")
        @CanIgnoreReturnValue
        public final Builder defaultParams(Config defaultParams) {
            this.defaultParams = (Config)Preconditions.checkNotNull((Object)defaultParams, (Object)"defaultParams");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="archiveType")
        @CanIgnoreReturnValue
        public final Builder archiveType(ArchiveType archiveType) {
            this.archiveType = (ArchiveType)Preconditions.checkNotNull((Object)archiveType, (Object)"archiveType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder archiveMd5(byte[] archiveMd5) {
            this.archiveMd5 = Optional.of((Object)archiveMd5);
            return this;
        }

        @JsonProperty(value="archiveMd5")
        @CanIgnoreReturnValue
        public final Builder archiveMd5(Optional<byte[]> archiveMd5) {
            this.archiveMd5 = (Optional)Preconditions.checkNotNull(archiveMd5, (Object)"archiveMd5");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder archivePath(String archivePath) {
            this.archivePath = Optional.of((Object)archivePath);
            return this;
        }

        @JsonProperty(value="archivePath")
        @CanIgnoreReturnValue
        public final Builder archivePath(Optional<String> archivePath) {
            this.archivePath = (Optional)Preconditions.checkNotNull(archivePath, (Object)"archivePath");
            return this;
        }

        @JsonProperty(value="userInfo")
        @CanIgnoreReturnValue
        public final Builder userInfo(Config userInfo) {
            this.userInfo = (Config)Preconditions.checkNotNull((Object)userInfo, (Object)"userInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableStoredRevision build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStoredRevision.validate(new ImmutableStoredRevision(this.id, this.projectId, this.createdAt, this.name, this.defaultParams, this.archiveType, this.archiveMd5, this.archivePath, this.userInfo));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("defaultParams");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("archiveType");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("userInfo");
            }
            return "Cannot build StoredRevision, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredRevision {
        int id;
        boolean idIsSet;
        int projectId;
        boolean projectIdIsSet;
        @Nullable
        Instant createdAt;
        @Nullable
        String name;
        @Nullable
        Config defaultParams;
        @Nullable
        ArchiveType archiveType;
        Optional<byte[]> archiveMd5 = Optional.absent();
        Optional<String> archivePath = Optional.absent();
        @Nullable
        Config userInfo;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(int id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="defaultParams")
        public void setDefaultParams(Config defaultParams) {
            this.defaultParams = defaultParams;
        }

        @JsonProperty(value="archiveType")
        public void setArchiveType(ArchiveType archiveType) {
            this.archiveType = archiveType;
        }

        @JsonProperty(value="archiveMd5")
        public void setArchiveMd5(Optional<byte[]> archiveMd5) {
            this.archiveMd5 = archiveMd5;
        }

        @JsonProperty(value="archivePath")
        public void setArchivePath(Optional<String> archivePath) {
            this.archivePath = archivePath;
        }

        @JsonProperty(value="userInfo")
        public void setUserInfo(Config userInfo) {
            this.userInfo = userInfo;
        }

        @Override
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProjectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getDefaultParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchiveType getArchiveType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<byte[]> getArchiveMd5() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getArchivePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getUserInfo() {
            throw new UnsupportedOperationException();
        }
    }
}

