/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.queue;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.core.agent.AgentId;
import io.digdag.core.queue.QueueSettingStoreManager;
import io.digdag.core.queue.TaskQueueServerManager;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.workflow.TaskQueueDispatcher;
import io.digdag.spi.TaskConflictException;
import io.digdag.spi.TaskNotFoundException;
import io.digdag.spi.TaskQueueRequest;
import io.digdag.spi.TaskQueueServer;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;

public class QueueTaskQueueDispatcher
implements TaskQueueDispatcher {
    private final AtomicLong enqueueCount = new AtomicLong(0L);
    private final QueueSettingStoreManager queueManager;
    private final TaskQueueServer taskQueueServer;

    @Inject
    public QueueTaskQueueDispatcher(QueueSettingStoreManager queueManager, TaskQueueServerManager queueServerManager) {
        this.queueManager = queueManager;
        this.taskQueueServer = queueServerManager.getTaskQueueServer();
    }

    @Managed
    public long getEnqueueCount() {
        return this.enqueueCount.get();
    }

    @Override
    public void dispatch(int siteId, Optional<String> queueName, TaskQueueRequest request) throws ResourceNotFoundException, TaskConflictException {
        this.enqueueCount.incrementAndGet();
        if (queueName.isPresent()) {
            int queueId = this.queueManager.getQueueIdByName(siteId, (String)queueName.get());
            this.taskQueueServer.enqueueQueueBoundTask(queueId, request);
        } else {
            this.taskQueueServer.enqueueDefaultQueueTask(siteId, request);
        }
    }

    @Override
    public void taskFinished(int siteId, String lockId, AgentId agentId) throws TaskConflictException, TaskNotFoundException {
        this.taskQueueServer.deleteTask(siteId, lockId, agentId.toString());
    }

    @Override
    public boolean deleteInconsistentTask(String lockId) {
        return this.taskQueueServer.forceDeleteTask(lockId);
    }
}

