/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.plugin;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class PluginClassLoader
extends URLClassLoader {
    private final List<String> parentFirstPackagePrefixes;
    private final List<String> parentFirstResourcePrefixes;

    public PluginClassLoader(Collection<? extends URL> urls, ClassLoader parent, Collection<String> parentFirstPackages, Collection<String> parentFirstResources) {
        super(urls.toArray(new URL[urls.size()]), parent);
        this.parentFirstPackagePrefixes = ImmutableList.copyOf((Iterable)Iterables.transform(parentFirstPackages, (Function)new Function<String, String>(){

            public String apply(String pkg) {
                return pkg + ".";
            }
        }));
        this.parentFirstResourcePrefixes = ImmutableList.copyOf((Iterable)Iterables.transform(parentFirstResources, (Function)new Function<String, String>(){

            public String apply(String pkg) {
                return pkg + "/";
            }
        }));
    }

    public void addPath(Path path) {
        try {
            this.addUrl(path.toUri().toURL());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void addUrl(URL url) {
        super.addURL(url);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass != null) {
                return this.resolveClass(loadedClass, resolve);
            }
            boolean parentFirst = this.isParentFirstPackage(name);
            if (!parentFirst) {
                try {
                    return this.resolveClass(this.findClass(name), resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            try {
                return this.resolveClass(this.getParent().loadClass(name), resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (parentFirst) {
                    return this.resolveClass(this.findClass(name), resolve);
                }
                throw new ClassNotFoundException(name);
            }
        }
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL childUrl;
        URL childUrl2;
        boolean childFirst = this.isParentFirstPath(name);
        if (childFirst && (childUrl2 = this.findResource(name)) != null) {
            return childUrl2;
        }
        URL parentUrl = this.getParent().getResource(name);
        if (parentUrl != null) {
            return parentUrl;
        }
        if (!childFirst && (childUrl = this.findResource(name)) != null) {
            return childUrl;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<UnmodifiableIterator> resources = new ArrayList<UnmodifiableIterator>();
        boolean parentFirst = this.isParentFirstPath(name);
        if (!parentFirst) {
            UnmodifiableIterator childResources = Iterators.forEnumeration(this.findResources(name));
            resources.add(childResources);
        }
        UnmodifiableIterator parentResources = Iterators.forEnumeration(this.getParent().getResources(name));
        resources.add(parentResources);
        if (parentFirst) {
            UnmodifiableIterator childResources = Iterators.forEnumeration(this.findResources(name));
            resources.add(childResources);
        }
        return Iterators.asEnumeration((Iterator)Iterators.concat(resources.iterator()));
    }

    private boolean isParentFirstPackage(String name) {
        for (String pkg : this.parentFirstPackagePrefixes) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentFirstPath(String name) {
        for (String path : this.parentFirstResourcePrefixes) {
            if (!name.startsWith(path)) continue;
            return true;
        }
        return false;
    }
}

