/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import io.digdag.core.log.LogLevel;
import io.digdag.core.log.TaskLogger;

public class TaskContextLogging {
    private static final InheritableThreadLocal<Context> contexts = new InheritableThreadLocal();

    public static void enter(String level, TaskLogger logger) {
        TaskContextLogging.enter(LogLevel.of(level), logger);
    }

    public static void enter(LogLevel level, TaskLogger logger) {
        if (TaskContextLogging.getContext() != null) {
            throw new IllegalStateException("Context logger already set");
        }
        contexts.set(new Context(level, logger));
    }

    public static void leave() {
        contexts.set(null);
    }

    public static Context getContext() {
        return (Context)contexts.get();
    }

    public static class Context {
        private final int filterLevel;
        private final TaskLogger logger;

        private Context(LogLevel filterLevel, TaskLogger logger) {
            this.filterLevel = filterLevel.toInt();
            this.logger = logger;
        }

        public boolean matches(LogLevel level) {
            return this.filterLevel <= level.toInt();
        }

        public TaskLogger getLogger() {
            return this.logger;
        }
    }
}

