/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.zip.GZIPOutputStream;

class CountingLogOutputStream
extends GZIPOutputStream {
    private final Path path;
    private final Instant openTime;
    private int count;

    public CountingLogOutputStream(Path path) throws IOException {
        super(Files.newOutputStream(path, new OpenOption[0]), 8192);
        this.def.setLevel(9);
        this.path = path;
        this.openTime = Instant.now();
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.count += len;
    }

    public Path getPath() {
        return this.path;
    }

    public Instant getOpenTime() {
        return this.openTime;
    }

    public int getUncompressedSize() {
        return this.count;
    }
}

