/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import com.google.common.io.ByteStreams;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.TempFileManager;
import io.digdag.core.log.CountingLogOutputStream;
import io.digdag.core.log.LogLevel;
import io.digdag.core.log.TaskLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BufferedRemoteTaskLogger
implements TaskLogger {
    private static final int UPLOAD_THRESHOLD = 0x1000000;
    private final TempFileManager tempFiles;
    private final String tempFilePrefix;
    private final Uploader uploader;
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock.ReadLock logAppendLock;
    private final ReentrantReadWriteLock.WriteLock logUploadLock;
    private volatile CountingLogOutputStream currentFile = null;
    private volatile boolean closed;

    public BufferedRemoteTaskLogger(TempFileManager tempFiles, String tempFilePrefix, Uploader uploader) {
        this.tempFiles = tempFiles;
        this.tempFilePrefix = tempFilePrefix;
        this.uploader = uploader;
        this.lock = new ReentrantReadWriteLock();
        this.logAppendLock = this.lock.readLock();
        this.logUploadLock = this.lock.writeLock();
    }

    @Override
    public void log(LogLevel level, long timestamp, String message) {
        byte[] data = message.getBytes(StandardCharsets.UTF_8);
        this.log(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(byte[] data, int off, int len) {
        try {
            boolean uploadAfterUnlock = false;
            this.logAppendLock.lock();
            try {
                this.openCurrentFile();
                this.currentFile.write(data, off, len);
                if (this.currentFile.getUncompressedSize() > 0x1000000) {
                    uploadAfterUnlock = true;
                }
            }
            finally {
                this.logAppendLock.unlock();
            }
            if (uploadAfterUnlock) {
                this.tryUpload(false);
            }
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCurrentFile() throws IOException {
        if (this.currentFile == null) {
            BufferedRemoteTaskLogger bufferedRemoteTaskLogger = this;
            synchronized (bufferedRemoteTaskLogger) {
                if (this.currentFile == null) {
                    if (this.closed) {
                        throw new IOException("Task logger is already closed");
                    }
                    this.currentFile = new CountingLogOutputStream(this.tempFiles.createTempFile("logs", this.tempFilePrefix, ".log.gz").get());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryUpload(boolean atClose) throws IOException {
        this.logUploadLock.lock();
        try {
            if (this.currentFile != null && (atClose || this.currentFile.getUncompressedSize() > 0x1000000)) {
                byte[] gzData;
                this.currentFile.close();
                Path path = this.currentFile.getPath();
                Instant firstLogTime = this.currentFile.getOpenTime();
                this.currentFile = null;
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    gzData = ByteStreams.toByteArray((InputStream)in);
                }
                this.uploader.upload(firstLogTime, gzData);
                Files.deleteIfExists(path);
            }
            if (atClose) {
                this.closed = true;
            }
        }
        finally {
            this.logUploadLock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.tryUpload(true);
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    public static interface Uploader {
        public void upload(Instant var1, byte[] var2);
    }
}

