/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.database.ConfigKeyListMapper;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseProjectStoreManager;
import io.digdag.core.database.DatabaseQueueSettingStoreManager;
import io.digdag.core.database.DatabaseScheduleStoreManager;
import io.digdag.core.database.DatabaseSecretStore;
import io.digdag.core.database.DatabaseSessionStoreManager;
import io.digdag.core.database.DatabaseTaskQueueServer;
import io.digdag.core.database.Transaction;
import io.digdag.core.database.TransactionManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalTransactionManager
implements TransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManager.class);
    private final ThreadLocal<Transaction> threadLocalTransaction = new ThreadLocal();
    private final ThreadLocal<Transaction> threadLocalAutoCommitTransaction = new ThreadLocal();
    private final DataSource ds;

    @Inject
    public ThreadLocalTransactionManager(DataSource ds) {
        this(ds, false);
    }

    ThreadLocalTransactionManager(DataSource ds, boolean autoAutoCommit) {
        this.ds = (DataSource)Preconditions.checkNotNull((Object)ds);
        if (autoAutoCommit) {
            LazyTransaction transaction = new LazyTransaction(ds, true);
            this.threadLocalTransaction.set(transaction);
        }
    }

    @Override
    public Handle getHandle(ConfigMapper configMapper) {
        Transaction transaction = this.threadLocalTransaction.get();
        if (transaction == null && (transaction = this.threadLocalAutoCommitTransaction.get()) == null) {
            throw new IllegalStateException("Not in transaction");
        }
        return transaction.getHandle(configMapper);
    }

    @Override
    public <T> T begin(TransactionManager.SupplierInTransaction<T, RuntimeException, RuntimeException, RuntimeException, RuntimeException> func) {
        return this.begin(func, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    @Override
    public <T, E1 extends Exception> T begin(TransactionManager.SupplierInTransaction<T, E1, RuntimeException, RuntimeException, RuntimeException> func, Class<E1> e1) throws E1 {
        return this.begin(func, e1, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    @Override
    public <T, E1 extends Exception, E2 extends Exception> T begin(TransactionManager.SupplierInTransaction<T, E1, E2, RuntimeException, RuntimeException> func, Class<E1> e1, Class<E2> e2) throws E1, E2 {
        return this.begin(func, e1, e2, RuntimeException.class, RuntimeException.class);
    }

    @Override
    public <T, E1 extends Exception, E2 extends Exception, E3 extends Exception> T begin(TransactionManager.SupplierInTransaction<T, E1, E2, E3, RuntimeException> func, Class<E1> e1, Class<E2> e2, Class<E3> e3) throws E1, E2, E3 {
        return this.begin(func, e1, e2, e3, RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception> T begin(TransactionManager.SupplierInTransaction<T, E1, E2, E3, E4> func, Class<E1> e1, Class<E2> e2, Class<E3> e3, Class<E4> e4) throws E1, E2, E3, E4 {
        if (this.threadLocalTransaction.get() != null) {
            throw new IllegalStateException("Nested transaction is not allowed: " + this.threadLocalTransaction.get());
        }
        boolean committed = false;
        LazyTransaction transaction = new LazyTransaction(this.ds);
        try {
            this.threadLocalTransaction.set(transaction);
            T result = func.get();
            transaction.commit();
            committed = true;
            T t = result;
            return t;
        }
        catch (Exception e) {
            ThrowablesUtil.propagateIfInstanceOf((Throwable)e, e1);
            ThrowablesUtil.propagateIfInstanceOf((Throwable)e, e2);
            ThrowablesUtil.propagateIfInstanceOf((Throwable)e, e3);
            ThrowablesUtil.propagateIfInstanceOf((Throwable)e, e4);
            throw ThrowablesUtil.propagate((Throwable)e);
        }
        finally {
            this.threadLocalTransaction.set(null);
            try {
                if (!committed) {
                    transaction.abort();
                }
            }
            finally {
                transaction.close();
            }
        }
    }

    @Override
    public <T> T autoCommit(TransactionManager.SupplierInTransaction<T, RuntimeException, RuntimeException, RuntimeException, RuntimeException> func) {
        return this.autoCommit(func, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    @Override
    public <T, E1 extends Exception> T autoCommit(TransactionManager.SupplierInTransaction<T, E1, RuntimeException, RuntimeException, RuntimeException> func, Class<E1> e1) throws E1 {
        return this.autoCommit(func, e1, RuntimeException.class, RuntimeException.class);
    }

    @Override
    public <T, E1 extends Exception, E2 extends Exception> T autoCommit(TransactionManager.SupplierInTransaction<T, E1, E2, RuntimeException, RuntimeException> func, Class<E1> e1, Class<E2> e2) throws E1, E2 {
        return this.autoCommit(func, e1, e2, RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, E1 extends Exception, E2 extends Exception, E3 extends Exception> T autoCommit(TransactionManager.SupplierInTransaction<T, E1, E2, E3, RuntimeException> func, Class<E1> e1, Class<E2> e2, Class<E3> e3) throws E1, E2, E3 {
        try {
            if (this.threadLocalTransaction.get() != null) {
                return func.get();
            }
            LazyTransaction transaction = new LazyTransaction(this.ds, true);
            this.threadLocalAutoCommitTransaction.set(transaction);
            try {
                T t = func.get();
                return t;
            }
            finally {
                this.threadLocalAutoCommitTransaction.set(null);
                transaction.close();
            }
        }
        catch (Exception e) {
            ThrowablesUtil.propagateIfInstanceOf((Throwable)e, e1);
            ThrowablesUtil.propagateIfInstanceOf((Throwable)e, e2);
            ThrowablesUtil.propagateIfInstanceOf((Throwable)e, e3);
            throw ThrowablesUtil.propagate((Throwable)e);
        }
    }

    @Override
    public void reset() {
        Transaction transaction = this.threadLocalTransaction.get();
        if (transaction == null) {
            throw new IllegalStateException("Not in transaction");
        }
        transaction.reset();
    }

    private static class LazyTransaction
    implements Transaction {
        private final DataSource ds;
        private final boolean autoAutoCommit;
        private Handle handle;
        private State state = State.ACTIVE;
        private final StackTraceElement[] stackTrace;

        LazyTransaction(DataSource ds) {
            this(ds, false);
        }

        LazyTransaction(DataSource ds, boolean autoAutoCommit) {
            this.ds = (DataSource)Preconditions.checkNotNull((Object)ds);
            this.autoAutoCommit = autoAutoCommit;
            this.stackTrace = Thread.currentThread().getStackTrace();
        }

        @Override
        public Handle getHandle(ConfigMapper configMapper) {
            if (this.state != State.ACTIVE) {
                throw new IllegalStateException("Transaction is already " + this.state.name().toLowerCase(Locale.ENGLISH));
            }
            if (this.handle == null) {
                DBI dbi = new DBI(this.ds);
                ConfigKeyListMapper cklm = new ConfigKeyListMapper();
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.StoredProjectMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.StoredProjectWithRevisionMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.StoredRevisionMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.StoredWorkflowDefinitionMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.StoredWorkflowDefinitionWithProjectMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.WorkflowConfigMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.IdNameMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseProjectStoreManager.ScheduleStatusMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseQueueSettingStoreManager.StoredQueueSettingMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseScheduleStoreManager.StoredScheduleMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.StoredTaskMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.ArchivedTaskMapper(cklm, configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.ResumingTaskMapper(cklm, configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.StoredSessionMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.StoredSessionWithLastAttemptMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.StoredSessionAttemptMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.StoredSessionAttemptWithSessionMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.TaskStateSummaryMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.TaskAttemptSummaryMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.SessionAttemptSummaryMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.StoredSessionMonitorMapper(configMapper));
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.StoredDelayedSessionAttemptMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.TaskRelationMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseSessionStoreManager.InstantMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseSecretStore.ScopedSecretMapper());
                dbi.registerMapper((ResultSetMapper)new DatabaseTaskQueueServer.ImmutableTaskQueueLockMapper());
                dbi.registerArgumentFactory((ArgumentFactory)configMapper.getArgumentFactory());
                this.handle = dbi.open();
                try {
                    this.handle.getConnection().setAutoCommit(this.autoAutoCommit);
                }
                catch (SQLException ex) {
                    throw new TransactionFailedException("Failed to set auto commit: " + this.autoAutoCommit, (Throwable)ex);
                }
                if (!this.autoAutoCommit) {
                    this.handle.begin();
                }
            }
            return this.handle;
        }

        @Override
        public void commit() {
            boolean isValid;
            if (this.handle == null) {
                return;
            }
            if (this.state != State.ACTIVE) {
                throw new IllegalStateException("Committing " + this.state.name().toLowerCase(Locale.ENGLISH) + " is not allowed");
            }
            try {
                isValid = this.handle.getConnection().isValid(30);
            }
            catch (SQLException ex) {
                throw new TransactionFailedException("Can't validate a transaction before commit", (Throwable)ex);
            }
            if (!isValid) {
                throw new TransactionFailedException("Trying to commit a transaction that is already aborted. Because current transaction is aborted, commands including commit are ignored until end of transaction block.");
            }
            this.handle.commit();
            this.state = State.COMMITTED;
        }

        @Override
        public void abort() {
            if (this.handle == null) {
                return;
            }
            if (this.state == State.COMMITTED) {
                throw new IllegalStateException("Aborting committed transaction is not allowed");
            }
            if (!this.autoAutoCommit) {
                this.handle.rollback();
            }
            this.state = State.ABORTED;
        }

        @Override
        public void reset() {
            this.abort();
            this.state = State.ACTIVE;
        }

        void close() {
            if (this.handle != null) {
                this.handle.close();
            }
        }

        public String toString() {
            return "LazyTransaction{autoAutoCommit=" + this.autoAutoCommit + ", handle=" + this.handle + ", state=" + (Object)((Object)this.state) + ", stackTrace=[\n" + Arrays.stream(this.stackTrace).map(st -> "  " + st.toString()).collect(Collectors.joining("\n")) + "\n]}";
        }

        private static enum State {
            ACTIVE,
            ABORTED,
            COMMITTED;

        }
    }
}

