/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Optional;
import io.digdag.core.crypto.SecretCrypto;
import io.digdag.core.database.BasicDatabaseStoreManager;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.TransactionManager;
import io.digdag.spi.SecretStore;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

class DatabaseSecretStore
extends BasicDatabaseStoreManager<Dao>
implements SecretStore {
    private final int siteId;
    private final TransactionManager tm;
    private final SecretCrypto crypto;

    DatabaseSecretStore(DatabaseConfig config, TransactionManager tm, ConfigMapper cfm, int siteId, SecretCrypto crypto) {
        super(config.getType(), Dao.class, tm, cfm);
        this.siteId = siteId;
        this.tm = tm;
        this.crypto = crypto;
    }

    public Optional<String> getSecret(int projectId, String scope, String key) {
        EncryptedSecret secret = this.tm.begin(() -> this.autoCommit((handle, dao) -> dao.getProjectSecret(this.siteId, projectId, scope, key)));
        if (secret == null) {
            return Optional.absent();
        }
        if (!this.crypto.getName().equals(secret.engine)) {
            throw new AssertionError((Object)String.format(Locale.ENGLISH, "Crypto engine mismatch. Expected '%s' but got '%s'", secret.engine, this.crypto.getName()));
        }
        String decrypted = this.crypto.decryptSecret(secret.value);
        return Optional.of((Object)decrypted);
    }

    static class ScopedSecretMapper
    implements ResultSetMapper<EncryptedSecret> {
        ScopedSecretMapper() {
        }

        public EncryptedSecret map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new EncryptedSecret(r.getString("engine"), r.getString("value"));
        }
    }

    static class EncryptedSecret {
        final String engine;
        final String value;

        private EncryptedSecret(String engine, String value) {
            this.engine = engine;
            this.value = value;
        }
    }

    static interface Dao {
        @SqlQuery(value="select engine, value from secrets where site_id = :siteId and project_id = :projectId and key = :key and scope = :scope")
        public EncryptedSecret getProjectSecret(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="scope") String var3, @Bind(value="key") String var4);
    }
}

