/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Optional;
import io.digdag.core.crypto.SecretCrypto;
import io.digdag.core.database.BasicDatabaseStoreManager;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.DatabaseSecretStore;
import io.digdag.core.database.TransactionManager;
import io.digdag.spi.SecretControlStore;
import java.util.List;
import java.util.Locale;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;

class DatabaseSecretControlStore
extends BasicDatabaseStoreManager<Dao>
implements SecretControlStore {
    private final int siteId;
    private final SecretCrypto crypto;

    DatabaseSecretControlStore(DatabaseConfig config, TransactionManager transactionManager, ConfigMapper cfm, int siteId, SecretCrypto crypto) {
        super(config.getType(), DatabaseSecretControlStore.dao(config.getType()), transactionManager, cfm);
        this.siteId = siteId;
        this.crypto = crypto;
    }

    private static Class<? extends Dao> dao(String type) {
        switch (type) {
            case "postgresql": {
                return PgDao.class;
            }
            case "h2": {
                return H2Dao.class;
            }
        }
        throw new IllegalArgumentException("Unknown database type: " + type);
    }

    public void setProjectSecret(int projectId, String scope, String key, String value) {
        this.transaction((handle, dao) -> {
            new LockedControl(handle, (Dao)dao).setProjectSecret(projectId, scope, key, value);
            return null;
        });
    }

    public void deleteProjectSecret(int projectId, String scope, String key) {
        this.transaction((handle, dao) -> {
            new LockedControl(handle, (Dao)dao).deleteProjectSecret(projectId, scope, key);
            return null;
        });
    }

    public List<String> listProjectSecrets(int projectId, String scope) {
        return this.transaction((handle, dao) -> new LockedControl(handle, (Dao)dao).listProjectSecrets(projectId, scope));
    }

    public <T> T lockProjectSecret(int projectId, String scope, String key, SecretControlStore.SecretLockAction<T> action) {
        return (T)this.transaction((handle, dao) -> new LockedControl(handle, (Dao)dao).lockProjectSecret(projectId, scope, key, action));
    }

    static interface H2Dao
    extends Dao {
        @Override
        @SqlUpdate(value="merge into secrets  (site_id, project_id, scope, key, engine, value, updated_at) key(site_id, project_id, scope, key) values (:siteId, :projectId, :scope, :key, :engine, :value, now())")
        public int upsertProjectSecret(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="scope") String var3, @Bind(value="key") String var4, @Bind(value="engine") String var5, @Bind(value="value") String var6);
    }

    static interface PgDao
    extends Dao {
        @Override
        @SqlUpdate(value="insert into secrets (site_id, project_id, scope, key, engine, value, updated_at) values (:siteId, :projectId, :scope, :key, :engine, :value, now()) on conflict (site_id, project_id, scope, key) do update set engine = :engine, value = :value, updated_at = now()")
        public int upsertProjectSecret(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="scope") String var3, @Bind(value="key") String var4, @Bind(value="engine") String var5, @Bind(value="value") String var6);
    }

    static interface Dao {
        @SqlQuery(value="select key from secrets where site_id = :siteId and project_id = :projectId and scope = :scope")
        public List<String> listProjectSecrets(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="scope") String var3);

        @SqlUpdate(value="delete from secrets where site_id = :siteId and project_id = :projectId and scope = :scope and key = :key")
        public int deleteProjectSecret(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="scope") String var3, @Bind(value="key") String var4);

        public int upsertProjectSecret(int var1, int var2, String var3, String var4, String var5, String var6);

        @SqlQuery(value="select engine, value from secrets where site_id = :siteId and project_id = :projectId and scope = :scope and key = :key for update")
        public DatabaseSecretStore.EncryptedSecret lockProjectSecret(@Bind(value="siteId") int var1, @Bind(value="projectId") int var2, @Bind(value="scope") String var3, @Bind(value="key") String var4);
    }

    private class LockedControl
    implements SecretControlStore {
        private final Handle handle;
        private final Dao dao;

        public LockedControl(Handle handle, Dao dao) {
            this.handle = handle;
            this.dao = dao;
        }

        public void setProjectSecret(int projectId, String scope, String key, String value) {
            String encrypted = DatabaseSecretControlStore.this.crypto.encryptSecret(value);
            String engine = DatabaseSecretControlStore.this.crypto.getName();
            this.dao.upsertProjectSecret(DatabaseSecretControlStore.this.siteId, projectId, scope, key, engine, encrypted);
        }

        public void deleteProjectSecret(int projectId, String scope, String key) {
            this.dao.deleteProjectSecret(DatabaseSecretControlStore.this.siteId, projectId, scope, key);
        }

        public List<String> listProjectSecrets(int projectId, String scope) {
            return this.dao.listProjectSecrets(DatabaseSecretControlStore.this.siteId, projectId, scope);
        }

        public <T> T lockProjectSecret(int projectId, String scope, String key, SecretControlStore.SecretLockAction<T> action) {
            Optional value;
            DatabaseSecretStore.EncryptedSecret secret = this.dao.lockProjectSecret(DatabaseSecretControlStore.this.siteId, projectId, scope, key);
            if (secret == null) {
                value = Optional.absent();
            } else {
                if (!DatabaseSecretControlStore.this.crypto.getName().equals(secret.engine)) {
                    throw new AssertionError((Object)String.format(Locale.ENGLISH, "Crypto engine mismatch. Expected '%s' but got '%s'", secret.engine, DatabaseSecretControlStore.this.crypto.getName()));
                }
                String decrypted = DatabaseSecretControlStore.this.crypto.decryptSecret(secret.value);
                value = Optional.of((Object)decrypted);
            }
            return (T)action.call((SecretControlStore)this, value);
        }
    }
}

