/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DataSourceProvider;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.DatabaseConfigProvider;
import io.digdag.core.database.DatabaseMigrator;
import io.digdag.core.database.DatabaseProjectStoreManager;
import io.digdag.core.database.DatabaseQueueSettingStoreManager;
import io.digdag.core.database.DatabaseScheduleStoreManager;
import io.digdag.core.database.DatabaseSessionStoreManager;
import io.digdag.core.database.DatabaseTaskQueueConfig;
import io.digdag.core.database.DatabaseTaskQueueServer;
import io.digdag.core.database.ThreadLocalTransactionManager;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.queue.QueueSettingStoreManager;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.schedule.ScheduleStoreManager;
import io.digdag.core.session.SessionStoreManager;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.skife.jdbi.v2.DBI;

public class DatabaseModule
implements Module {
    private boolean withTaskQueueServer;

    public DatabaseModule(boolean withTaskQueueServer) {
        this.withTaskQueueServer = withTaskQueueServer;
    }

    public void configure(Binder binder) {
        binder.bind(DatabaseConfig.class).toProvider(DatabaseConfigProvider.class).in(Scopes.SINGLETON);
        binder.bind(DataSource.class).toProvider(DataSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(AutoMigrator.class);
        binder.bind(DBI.class).toProvider(DbiProvider.class);
        binder.bind(TransactionManager.class).to(ThreadLocalTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ConfigMapper.class).in(Scopes.SINGLETON);
        binder.bind(DatabaseMigrator.class).in(Scopes.SINGLETON);
        binder.bind(ProjectStoreManager.class).to(DatabaseProjectStoreManager.class).in(Scopes.SINGLETON);
        binder.bind(QueueSettingStoreManager.class).to(DatabaseQueueSettingStoreManager.class).in(Scopes.SINGLETON);
        binder.bind(SessionStoreManager.class).to(DatabaseSessionStoreManager.class).in(Scopes.SINGLETON);
        binder.bind(ScheduleStoreManager.class).to(DatabaseScheduleStoreManager.class).in(Scopes.SINGLETON);
        if (this.withTaskQueueServer) {
            binder.bind(DatabaseTaskQueueConfig.class).in(Scopes.SINGLETON);
            binder.bind(DatabaseTaskQueueServer.class).in(Scopes.SINGLETON);
        }
    }

    public static class DbiProvider
    implements Provider<DBI> {
        private final DataSource ds;

        @Inject
        public DbiProvider(DataSource ds, AutoMigrator migrator) {
            this.ds = ds;
        }

        public DBI get() {
            return new DBI(this.ds);
        }
    }

    public static class AutoMigrator {
        private DatabaseMigrator migrator;

        @Inject
        public AutoMigrator(DataSource ds, DatabaseConfig config) {
            if (config.getAutoMigrate()) {
                this.migrator = new DatabaseMigrator(new DBI(ds), config);
            }
        }

        @PostConstruct
        public void migrate() {
            if (this.migrator != null) {
                this.migrator.migrate();
                this.migrator = null;
            }
        }
    }
}

