/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.config;

import java.util.regex.Pattern;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlTagResolver
extends Resolver {
    public static final Pattern FLOAT_EXCEPTING_ZERO_START = Pattern.compile("^([-+]?(\\.[0-9]+|[1-9][0-9_]*(\\.[0-9_]*)?)([eE][-+]?[0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");
    public static final Pattern INT_EXCEPTING_COLON = Pattern.compile("^(?:[-+]?0b[0-1_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*)$");

    public void addImplicitResolver(Tag tag, Pattern regexp, String first) {
        if (tag.equals((Object)Tag.FLOAT)) {
            super.addImplicitResolver(tag, FLOAT_EXCEPTING_ZERO_START, first);
        } else if (tag.equals((Object)Tag.INT)) {
            super.addImplicitResolver(tag, INT_EXCEPTING_COLON, first);
        } else if (tag.equals((Object)Tag.BOOL)) {
            super.addImplicitResolver(Tag.BOOL, Pattern.compile("^(?:[Tt]rue|[Ff]alse)$"), "TtFf");
        } else {
            if (tag.equals((Object)Tag.TIMESTAMP)) {
                return;
            }
            super.addImplicitResolver(tag, regexp, first);
        }
    }

    public Tag resolve(NodeId kind, String value, boolean implicit) {
        return super.resolve(kind, value, implicit);
    }
}

