/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.config;

import io.digdag.core.config.StrictSafeConstructor;
import java.util.UUID;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class YamlParameterizedConstructor
extends StrictSafeConstructor {
    public YamlParameterizedConstructor() {
        this.yamlConstructors.put(null, new CustomTagConstructor());
    }

    public static class TagException
    extends ConstructorException {
        public TagException(String message, Mark mark) {
            super(null, null, message, mark);
        }
    }

    private static class CustomTagConstructor
    extends AbstractConstruct {
        private CustomTagConstructor() {
        }

        public Object construct(Node node) {
            switch (node.getTag().getValue()) {
                case "!include": {
                    return "!include:" + UUID.randomUUID().toString();
                }
            }
            throw new TagException("could not determine a constructor for the tag " + node.getTag(), node.getStartMark());
        }

        private String validateScalar(Node node) {
            if (node.isTwoStepsConstruction()) {
                throw new TagException("'" + node.getTag() + "' cannot be recursive.", node.getStartMark());
            }
            if (!node.getNodeId().equals((Object)NodeId.scalar)) {
                throw new TagException("'" + node.getTag() + "' must be a string.", node.getStartMark());
            }
            return ((ScalarNode)node).getValue().toString();
        }
    }
}

