/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.client.config.ConfigFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static Properties loadFile(Path file) throws IOException {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            props.load(in);
        }
        return props;
    }

    public static ConfigElement toConfigElement(Properties props) {
        Config builder = new ConfigFactory(new ObjectMapper()).create();
        for (String key : props.stringPropertyNames()) {
            builder.set(key, (Object)props.getProperty(key));
        }
        return ConfigElement.copyOf((Config)builder);
    }

    public static Map<String, String> toMap(Properties props, String prefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            map.put(key.substring(prefix.length()), props.getProperty(key));
        }
        return map;
    }
}

