/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import io.digdag.spi.TaskRequest;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;

public class RuntimeParams {
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx", Locale.ENGLISH);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
    private static final DateTimeFormatter DATE_COMPACT_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd", Locale.ENGLISH);
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static final DateTimeFormatter DATETIME_COMPACT_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.ENGLISH);
    private static final DateTimeFormatter TZ_OFFSET_FORMAT = DateTimeFormatter.ofPattern("xx", Locale.ENGLISH);

    public static Config buildRuntimeParams(ConfigFactory cf, TaskRequest request) {
        Instant instant;
        String st2;
        Config params = cf.create();
        ZoneId timeZone = request.getTimeZone();
        params.set("timezone", (Object)timeZone);
        params.set("session_uuid", (Object)request.getSessionUuid().toString());
        params.set("session_time", (Object)RuntimeParams.formatSessionTime(request.getSessionTime(), timeZone));
        params.set("session_id", (Object)request.getSessionId());
        RuntimeParams.setTimeParameters(params, "session_", timeZone, request.getSessionTime());
        try {
            st2 = (String)request.getConfig().get("last_session_time", String.class, null);
            if (st2 != null) {
                instant = Instant.from(TIME_FORMAT.parse(st2));
                RuntimeParams.setTimeParameters(params, "last_session_", timeZone, instant);
            }
        }
        catch (ConfigException | DateTimeParseException st2) {
            // empty catch block
        }
        try {
            String sat = (String)request.getConfig().get("last_executed_session_time", String.class, null);
            if (sat != null) {
                instant = Instant.from(TIME_FORMAT.parse(sat));
                RuntimeParams.setTimeParameters(params, "last_executed_session_", timeZone, instant);
            } else {
                RuntimeParams.setEmptyTimeParameters(params, "last_executed_session_", timeZone);
            }
        }
        catch (ConfigException | DateTimeParseException sat) {
            // empty catch block
        }
        try {
            st2 = (String)request.getConfig().get("next_session_time", String.class, null);
            if (st2 != null) {
                instant = Instant.from(TIME_FORMAT.parse(st2));
                RuntimeParams.setTimeParameters(params, "next_session_", timeZone, instant);
            }
        }
        catch (ConfigException | DateTimeParseException throwable) {
            // empty catch block
        }
        params.set("project_id", (Object)request.getProjectId());
        params.set("retry_attempt_name", request.getRetryAttemptName().orNull());
        params.set("attempt_id", (Object)request.getAttemptId());
        params.set("task_name", (Object)request.getTaskName());
        return params;
    }

    private static void setTimeParameters(Config params, String prefix, ZoneId timeZone, Instant instant) {
        params.set(prefix + "date", (Object)DATE_FORMAT.withZone(timeZone).format(instant));
        params.set(prefix + "date_compact", (Object)DATE_COMPACT_FORMAT.withZone(timeZone).format(instant));
        params.set(prefix + "local_time", (Object)DATETIME_FORMAT.withZone(timeZone).format(instant));
        params.set(prefix + "tz_offset", (Object)TZ_OFFSET_FORMAT.withZone(timeZone).format(instant));
        params.set(prefix + "unixtime", (Object)instant.getEpochSecond());
    }

    private static void setEmptyTimeParameters(Config params, String prefix, ZoneId timeZone) {
        params.set(prefix + "time", (Object)"");
        params.set(prefix + "date", (Object)"");
        params.set(prefix + "date_compact", (Object)"");
        params.set(prefix + "local_time", (Object)"");
        params.set(prefix + "tz_offset", (Object)TZ_OFFSET_FORMAT.withZone(timeZone).format(Instant.ofEpochSecond(0L)));
        params.set(prefix + "unixtime", (Object)"");
    }

    public static String formatSessionTime(Instant instant, ZoneId timeZone) {
        return TIME_FORMAT.withZone(timeZone).format(instant);
    }
}

