/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.agent.TaskCallbackApi;
import io.digdag.core.repository.ResourceLimitExceededException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.workflow.SessionAttemptConflictException;
import io.digdag.spi.Operator;
import io.digdag.spi.OperatorContext;
import io.digdag.spi.OperatorFactory;
import io.digdag.spi.TaskExecutionException;
import io.digdag.spi.TaskResult;
import io.digdag.util.BaseOperator;
import java.time.Instant;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequireOperatorFactory
implements OperatorFactory {
    private static final int MAX_TASK_RETRY_INTERVAL = 10;
    private static Logger logger = LoggerFactory.getLogger(RequireOperatorFactory.class);
    private final TaskCallbackApi callback;

    @Inject
    public RequireOperatorFactory(TaskCallbackApi callback) {
        this.callback = callback;
    }

    public String getType() {
        return "require";
    }

    public Operator newOperator(OperatorContext context) {
        return new RequireOperator(context, this.callback);
    }

    static enum OptionRerunOn {
        NONE,
        FAILED,
        ALL;


        static OptionRerunOn of(String name) {
            switch (name) {
                case "none": {
                    return NONE;
                }
                case "failed": {
                    return FAILED;
                }
                case "all": {
                    return ALL;
                }
            }
            throw new ConfigException("invalid rerun_on option:" + name);
        }
    }

    private static class RequireOperator
    extends BaseOperator {
        private final TaskCallbackApi callback;
        private ConfigFactory cf;

        private RequireOperator(OperatorContext context, TaskCallbackApi callback) {
            super(context);
            this.callback = callback;
            this.cf = this.request.getConfig().getFactory();
        }

        public TaskResult runTask() {
            Config config = this.request.getConfig();
            Config localConfig = this.request.getLocalConfig();
            Config lastStateParams = this.request.getLastStateParams();
            String workflowName = (String)config.get("_command", String.class);
            Instant instant = (Instant)config.get("session_time", Instant.class);
            boolean ignoreFailure = (Boolean)config.get("ignore_failure", Boolean.TYPE, (Object)false);
            OptionRerunOn rerunOn = OptionRerunOn.of((String)config.get("rerun_on", String.class, (Object)"none"));
            Optional retryAttemptName = localConfig.getOptional("retry_attempt_name", String.class);
            if (lastStateParams.has("rerun_on_retry_attempt_name")) {
                retryAttemptName = lastStateParams.getOptional("rerun_on_retry_attempt_name", String.class);
            }
            Config overrideParams = config.getNestedOrGetEmpty("params");
            Optional projectIdentifier = Optional.absent();
            try {
                projectIdentifier = Optional.of((Object)this.makeProjectIdentifier());
                this.callback.startSession(this.context, this.request.getSiteId(), (TaskCallbackApi.ProjectIdentifier)projectIdentifier.get(), workflowName, instant, (Optional<String>)retryAttemptName, overrideParams);
                throw this.nextPolling(this.request.getLastStateParams().deepCopy().set("require_kicked", (Object)true));
            }
            catch (SessionAttemptConflictException ex) {
                return this.processAttempt(ex.getConflictedSession(), lastStateParams, rerunOn, ignoreFailure);
            }
            catch (ResourceNotFoundException ex) {
                throw new TaskExecutionException(String.format(Locale.ENGLISH, "Dependent workflow does not exist. %s, workflowName:%s", projectIdentifier.transform(TaskCallbackApi.ProjectIdentifier::toString).or((Object)""), workflowName));
            }
            catch (ResourceLimitExceededException ex) {
                throw new TaskExecutionException((Throwable)ex);
            }
        }

        private TaskResult processAttempt(StoredSessionAttempt attempt, Config lastStateParams, OptionRerunOn rerunOn, boolean ignoreFailure) {
            if (attempt.getStateFlags().isDone()) {
                boolean requireKicked = (Boolean)lastStateParams.get("require_kicked", Boolean.TYPE, (Object)false);
                if (!requireKicked && (rerunOn == OptionRerunOn.ALL || rerunOn == OptionRerunOn.FAILED && !attempt.getStateFlags().isSuccess())) {
                    throw this.nextPolling(lastStateParams.deepCopy().set("rerun_on_retry_attempt_name", (Object)UUID.randomUUID().toString()));
                }
                if (!ignoreFailure && !attempt.getStateFlags().isSuccess()) {
                    throw new TaskExecutionException(String.format(Locale.ENGLISH, "Dependent workflow failed. Session id: %d, attempt id: %d", attempt.getSessionId(), attempt.getId()));
                }
                return TaskResult.empty((ConfigFactory)this.cf);
            }
            throw this.nextPolling(lastStateParams.deepCopy());
        }

        private TaskExecutionException nextPolling(Config stateParams) {
            int iteration = (Integer)stateParams.get("retry", Integer.TYPE, (Object)0);
            stateParams.set("retry", (Object)(iteration + 1));
            int interval = (int)Math.min(1.0 * Math.pow(2.0, iteration), 10.0);
            return TaskExecutionException.ofNextPolling((int)interval, (ConfigElement)ConfigElement.copyOf((Config)stateParams));
        }

        private TaskCallbackApi.ProjectIdentifier makeProjectIdentifier() {
            Config config = this.request.getConfig();
            Config localConfig = this.request.getLocalConfig();
            int projectId = (Integer)config.get("project_id", Integer.TYPE);
            Optional projectIdParam = localConfig.getOptional("project_id", Integer.class);
            Optional projectNameParam = localConfig.getOptional("project_name", String.class);
            if (projectIdParam.isPresent() && projectNameParam.isPresent()) {
                throw new ConfigException("Both project_id and project_name can't be set");
            }
            TaskCallbackApi.ProjectIdentifier projectIdentifier = projectNameParam.isPresent() ? TaskCallbackApi.ProjectIdentifier.ofName((String)projectNameParam.get()) : (projectIdParam.isPresent() ? TaskCallbackApi.ProjectIdentifier.ofId((Integer)projectIdParam.get()) : TaskCallbackApi.ProjectIdentifier.ofId(projectId));
            return projectIdentifier;
        }
    }
}

