/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.agent.AgentConfig;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableAgentConfig
implements AgentConfig {
    private final boolean enabled;
    private final int heartbeatInterval;
    private final int lockRetentionTime;
    private final int maxThreads;

    private ImmutableAgentConfig(boolean enabled, int heartbeatInterval, int lockRetentionTime, int maxThreads) {
        this.enabled = enabled;
        this.heartbeatInterval = heartbeatInterval;
        this.lockRetentionTime = lockRetentionTime;
        this.maxThreads = maxThreads;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="heartbeatInterval")
    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    @JsonProperty(value="lockRetentionTime")
    public int getLockRetentionTime() {
        return this.lockRetentionTime;
    }

    @Override
    @JsonProperty(value="maxThreads")
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public final ImmutableAgentConfig withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableAgentConfig(value, this.heartbeatInterval, this.lockRetentionTime, this.maxThreads);
    }

    public final ImmutableAgentConfig withHeartbeatInterval(int value) {
        if (this.heartbeatInterval == value) {
            return this;
        }
        return new ImmutableAgentConfig(this.enabled, value, this.lockRetentionTime, this.maxThreads);
    }

    public final ImmutableAgentConfig withLockRetentionTime(int value) {
        if (this.lockRetentionTime == value) {
            return this;
        }
        return new ImmutableAgentConfig(this.enabled, this.heartbeatInterval, value, this.maxThreads);
    }

    public final ImmutableAgentConfig withMaxThreads(int value) {
        if (this.maxThreads == value) {
            return this;
        }
        return new ImmutableAgentConfig(this.enabled, this.heartbeatInterval, this.lockRetentionTime, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAgentConfig && this.equalTo((ImmutableAgentConfig)another);
    }

    private boolean equalTo(ImmutableAgentConfig another) {
        return this.enabled == another.enabled && this.heartbeatInterval == another.heartbeatInterval && this.lockRetentionTime == another.lockRetentionTime && this.maxThreads == another.maxThreads;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode((boolean)this.enabled);
        h = h * 17 + this.heartbeatInterval;
        h = h * 17 + this.lockRetentionTime;
        h = h * 17 + this.maxThreads;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AgentConfig").omitNullValues().add("enabled", this.enabled).add("heartbeatInterval", this.heartbeatInterval).add("lockRetentionTime", this.lockRetentionTime).add("maxThreads", this.maxThreads).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAgentConfig fromJson(Json json) {
        Builder builder = ImmutableAgentConfig.builder();
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        if (json.heartbeatIntervalIsSet) {
            builder.heartbeatInterval(json.heartbeatInterval);
        }
        if (json.lockRetentionTimeIsSet) {
            builder.lockRetentionTime(json.lockRetentionTime);
        }
        if (json.maxThreadsIsSet) {
            builder.maxThreads(json.maxThreads);
        }
        return builder.build();
    }

    public static ImmutableAgentConfig copyOf(AgentConfig instance) {
        if (instance instanceof ImmutableAgentConfig) {
            return (ImmutableAgentConfig)instance;
        }
        return ImmutableAgentConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private static final long INIT_BIT_HEARTBEAT_INTERVAL = 2L;
        private static final long INIT_BIT_LOCK_RETENTION_TIME = 4L;
        private static final long INIT_BIT_MAX_THREADS = 8L;
        private long initBits = 15L;
        private boolean enabled;
        private int heartbeatInterval;
        private int lockRetentionTime;
        private int maxThreads;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AgentConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.enabled(instance.getEnabled());
            this.heartbeatInterval(instance.getHeartbeatInterval());
            this.lockRetentionTime(instance.getLockRetentionTime());
            this.maxThreads(instance.getMaxThreads());
            return this;
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="heartbeatInterval")
        @CanIgnoreReturnValue
        public final Builder heartbeatInterval(int heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="lockRetentionTime")
        @CanIgnoreReturnValue
        public final Builder lockRetentionTime(int lockRetentionTime) {
            this.lockRetentionTime = lockRetentionTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="maxThreads")
        @CanIgnoreReturnValue
        public final Builder maxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAgentConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAgentConfig(this.enabled, this.heartbeatInterval, this.lockRetentionTime, this.maxThreads);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("heartbeatInterval");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lockRetentionTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("maxThreads");
            }
            return "Cannot build AgentConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements AgentConfig {
        boolean enabled;
        boolean enabledIsSet;
        int heartbeatInterval;
        boolean heartbeatIntervalIsSet;
        int lockRetentionTime;
        boolean lockRetentionTimeIsSet;
        int maxThreads;
        boolean maxThreadsIsSet;

        Json() {
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @JsonProperty(value="heartbeatInterval")
        public void setHeartbeatInterval(int heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
            this.heartbeatIntervalIsSet = true;
        }

        @JsonProperty(value="lockRetentionTime")
        public void setLockRetentionTime(int lockRetentionTime) {
            this.lockRetentionTime = lockRetentionTime;
            this.lockRetentionTimeIsSet = true;
        }

        @JsonProperty(value="maxThreads")
        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            this.maxThreadsIsSet = true;
        }

        @Override
        public boolean getEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHeartbeatInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLockRetentionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMaxThreads() {
            throw new UnsupportedOperationException();
        }
    }
}

