/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.core.agent.GraalJsEngine;
import io.digdag.core.agent.NashornJsEngine;
import io.digdag.metrics.DigdagTimed;
import io.digdag.spi.TemplateEngine;
import io.digdag.spi.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigEvalEngine
implements TemplateEngine {
    private static Logger logger = LoggerFactory.getLogger(ConfigEvalEngine.class);
    private static final String[][] LIBRARY_JS_RESOURCES = new String[][]{{"digdag.js", "/io/digdag/core/agent/digdag.js", "digdag.js"}, {"moment.min.js", "/io/digdag/core/agent/moment.min.js", "moment.min.js"}};
    static final String[][] LIBRARY_JS_CONTENTS = new String[LIBRARY_JS_RESOURCES.length][];
    private static ImmutableList<String> NO_EVALUATE_PARAMETERS;
    private final JsEngineType jsEngineType;
    private final NashornJsEngine nashorn;
    private final GraalJsEngine graal;
    private final ObjectMapper jsonMapper;
    private static final Pattern InvokeTemplateRequiredPattern;

    private static String readResource(String resourceName) {
        String string;
        block8: {
            InputStream in = ConfigEvalEngine.class.getResourceAsStream(resourceName);
            try {
                string = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            in.close();
        }
        return string;
    }

    private static JsEngineType parseJsEngineType(String type) {
        switch (type) {
            case "nashorn": {
                return JsEngineType.NASHORN;
            }
            case "graal": {
                return JsEngineType.GRAAL;
            }
            case "nashorn-graal-check": {
                return JsEngineType.NASHORN_GRAAL_CHECK;
            }
        }
        throw new ConfigException("Parameter 'eval.js-engine-type' must be either of nashorn, graal, or nashorn-graal-check but got " + type);
    }

    @VisibleForTesting
    static int getJavaVersionMajor() {
        String javaSpecVer = System.getProperty("java.specification.version");
        return Integer.parseInt(javaSpecVer.split("[^0-9]")[0]);
    }

    @VisibleForTesting
    static JsEngineType defaultJsEngineType() {
        if (ConfigEvalEngine.getJavaVersionMajor() < 11) {
            return JsEngineType.NASHORN;
        }
        return JsEngineType.GRAAL;
    }

    @Inject
    public ConfigEvalEngine(Config systemConfig) {
        this((JsEngineType)((Object)systemConfig.getOptional("eval.js-engine-type", String.class).transform(type -> ConfigEvalEngine.parseJsEngineType(type)).or(() -> ConfigEvalEngine.defaultJsEngineType())), (Boolean)systemConfig.get("eval.extended-syntax", Boolean.class, (Object)true));
    }

    @VisibleForTesting
    ConfigEvalEngine(JsEngineType jsEngineType, boolean extendedSyntax) {
        logger.debug("Using JavaScript engine: {}", (Object)jsEngineType.configName);
        this.jsEngineType = jsEngineType;
        switch (jsEngineType) {
            case NASHORN: {
                this.nashorn = new NashornJsEngine();
                this.graal = null;
                break;
            }
            case GRAAL: {
                this.nashorn = null;
                this.graal = new GraalJsEngine(extendedSyntax);
                break;
            }
            case NASHORN_GRAAL_CHECK: {
                this.nashorn = new NashornJsEngine();
                this.graal = new GraalJsEngine(extendedSyntax);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.jsonMapper = new ObjectMapper();
    }

    @DigdagTimed(value="ceval_", category="agent", appendMethodName=true)
    protected Config eval(Config config, Config params) throws TemplateException {
        ObjectNode built;
        ObjectNode object = (ObjectNode)config.convert(ObjectNode.class);
        switch (this.jsEngineType) {
            case NASHORN: {
                try (JsEngine.Evaluator evaluator = this.nashorn.newEvaluator(params);){
                    built = new Context(params, evaluator).evalObjectRecursive(object);
                    break;
                }
            }
            case GRAAL: {
                try (JsEngine.Evaluator evaluator = this.graal.newEvaluator(params);){
                    built = new Context(params, evaluator).evalObjectRecursive(object);
                    break;
                }
            }
            case NASHORN_GRAAL_CHECK: {
                try (JsEngine.Evaluator evaluator = this.nashorn.newEvaluator(params);
                     JsEngine.Evaluator checker = this.graal.newEvaluator(params);
                     CheckingJsEvaluator checkingEvaluator = new CheckingJsEvaluator(evaluator, checker);){
                    built = new Context(params, checkingEvaluator).evalObjectRecursive(object);
                    break;
                }
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return config.getFactory().create((Object)built);
    }

    @VisibleForTesting
    protected boolean isInvokeTemplateRequired(String code) {
        return code != null && InvokeTemplateRequiredPattern.matcher(code).find();
    }

    public String template(String content, Config params) throws TemplateException {
        String resultText = null;
        resultText = this.isInvokeTemplateRequired(content) ? this.callTemplate(content, params) : content;
        if (resultText == null) {
            return "";
        }
        return resultText;
    }

    public String callTemplate(String content, Config params) throws TemplateException {
        String resultText;
        switch (this.jsEngineType) {
            case NASHORN: {
                try (JsEngine.Evaluator evaluator = this.nashorn.newEvaluator(params);){
                    resultText = evaluator.evaluate(content, params, this.jsonMapper);
                    break;
                }
            }
            case GRAAL: {
                try (JsEngine.Evaluator evaluator = this.graal.newEvaluator(params);){
                    resultText = evaluator.evaluate(content, params, this.jsonMapper);
                    break;
                }
            }
            case NASHORN_GRAAL_CHECK: {
                try (JsEngine.Evaluator evaluator = this.nashorn.newEvaluator(params);
                     JsEngine.Evaluator checker = this.graal.newEvaluator(params);
                     CheckingJsEvaluator checkingEvaluator = new CheckingJsEvaluator(evaluator, checker);){
                    resultText = checkingEvaluator.evaluate(content, params, this.jsonMapper);
                    break;
                }
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (resultText == null) {
            return "";
        }
        return resultText;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static String stackTraceAsString(Throwable e) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                e.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            return "";
        }
    }

    static {
        for (int i = 0; i < LIBRARY_JS_RESOURCES.length; ++i) {
            ConfigEvalEngine.LIBRARY_JS_CONTENTS[i] = new String[]{LIBRARY_JS_RESOURCES[i][0], ConfigEvalEngine.readResource(LIBRARY_JS_RESOURCES[i][1])};
        }
        NO_EVALUATE_PARAMETERS = ImmutableList.of((Object)"_do", (Object)"_else_do");
        InvokeTemplateRequiredPattern = Pattern.compile("\\$");
    }

    private static class CheckingJsEvaluator
    implements JsEngine.Evaluator {
        private final JsEngine.Evaluator evaluator;
        private final JsEngine.Evaluator checker;

        CheckingJsEvaluator(JsEngine.Evaluator evaluator, JsEngine.Evaluator checker) {
            this.evaluator = evaluator;
            this.checker = checker;
        }

        @Override
        public String evaluate(String code, Config scopedParams, ObjectMapper jsonMapper) throws TemplateException {
            String resultText = null;
            String checkText = null;
            TemplateException resultEx = null;
            Exception checkEx = null;
            try {
                resultText = this.evaluator.evaluate(code, scopedParams, jsonMapper);
            }
            catch (TemplateException ex) {
                resultEx = ex;
            }
            try {
                checkText = this.checker.evaluate(code, scopedParams, jsonMapper);
            }
            catch (Exception ex) {
                checkEx = ex;
            }
            if (resultText == null && checkText != null || resultText != null && !resultText.equals(checkText)) {
                logger.debug("Detected incompatibility between Nashorn and GraalJS. Code: {}", (Object)code);
                logger.debug("Incompatibility info: Nashorn return:{} exception:{} GraalJS return:{} exception:{}", new Object[]{resultText == null ? "null" : resultText, resultEx == null ? "null" : resultEx.toString(), checkText == null ? "null" : checkText, checkEx == null ? "null" : checkEx.toString()});
            }
            if (resultEx != null) {
                throw resultEx;
            }
            return resultText;
        }
    }

    private class Context {
        private final Config params;
        private final JsEngine.Evaluator evaluator;

        public Context(Config params, JsEngine.Evaluator evaluator) {
            this.params = params;
            this.evaluator = evaluator;
        }

        private ObjectNode evalObjectRecursive(ObjectNode local) throws TemplateException {
            ObjectNode built = local.objectNode();
            for (Map.Entry pair : ImmutableList.copyOf((Iterator)local.fields())) {
                JsonNode evaluated;
                JsonNode value = (JsonNode)pair.getValue();
                if (NO_EVALUATE_PARAMETERS.contains(pair.getKey())) {
                    evaluated = value;
                } else if (value.isObject()) {
                    evaluated = this.evalObjectRecursive((ObjectNode)value);
                } else if (value.isArray()) {
                    evaluated = this.evalArrayRecursive(built, (ArrayNode)value);
                } else if (value.isTextual()) {
                    String code = value.textValue();
                    evaluated = this.evalValue(built, code);
                } else {
                    evaluated = value;
                }
                built.set((String)pair.getKey(), evaluated);
            }
            return built;
        }

        private ArrayNode evalArrayRecursive(ObjectNode local, ArrayNode array) throws TemplateException {
            ArrayNode built = array.arrayNode();
            for (JsonNode value : array) {
                ObjectNode evaluated;
                if (value.isObject()) {
                    evaluated = this.evalObjectRecursive((ObjectNode)value);
                } else if (value.isArray()) {
                    evaluated = this.evalArrayRecursive(local, (ArrayNode)value);
                } else if (value.isTextual()) {
                    String code = value.textValue();
                    evaluated = this.evalValue(local, code);
                } else {
                    evaluated = value;
                }
                built.add((JsonNode)evaluated);
            }
            return built;
        }

        private JsonNode evalValue(ObjectNode local, String code) throws TemplateException {
            Config scopedParams = this.params.deepCopy();
            for (Map.Entry pair : ImmutableList.copyOf((Iterator)local.fields())) {
                scopedParams.set((String)pair.getKey(), pair.getValue());
            }
            String resultText = null;
            resultText = ConfigEvalEngine.this.isInvokeTemplateRequired(code) ? this.evaluator.evaluate(code, scopedParams, ConfigEvalEngine.this.jsonMapper) : code;
            if (resultText == null) {
                return ConfigEvalEngine.this.jsonMapper.getNodeFactory().nullNode();
            }
            return ConfigEvalEngine.this.jsonMapper.getNodeFactory().textNode(resultText);
        }
    }

    static interface JsEngine {

        public static interface Evaluator
        extends AutoCloseable {
            public String evaluate(String var1, Config var2, ObjectMapper var3) throws TemplateException;

            @Override
            default public void close() {
            }
        }
    }

    static enum JsEngineType {
        NASHORN("nashorn"),
        GRAAL("graal"),
        NASHORN_GRAAL_CHECK("nashorn-graal-check");

        final String configName;

        private JsEngineType(String configName) {
            this.configName = configName;
        }
    }
}

