/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.validators;

import android.content.Context;
import android.view.View;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Toast;
import io.dflabs.lib.validators.FormValidator;

public class RadioGroupValidator
extends FormValidator.Validator {
    private final int errorMessage;
    private final RadioGroup radioGroup;

    public RadioGroupValidator(RadioGroup radioGroup, int errorMessage) {
        this.radioGroup = radioGroup;
        this.errorMessage = errorMessage;
    }

    @Override
    boolean isValid() {
        int count = this.radioGroup.getChildCount();
        boolean atLeastOneChecked = false;
        for (int i = 0; i < count; ++i) {
            View o = this.radioGroup.getChildAt(i);
            if (!(o instanceof RadioButton)) continue;
            atLeastOneChecked = ((RadioButton)o).isChecked() || atLeastOneChecked;
        }
        return atLeastOneChecked;
    }

    @Override
    void showError() {
        Toast.makeText((Context)this.context, (int)this.errorMessage, (int)0).show();
    }

    @Override
    void stopError() {
    }
}

