/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import io.dflabs.lib.interfaces.OnPhotoImport;
import io.dflabs.lib.interfaces.OnPhotoTaken;
import io.dflabs.lib.interfaces.OnVideoImport;
import io.dflabs.lib.utils.CameraImportTask;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CameraUtils {
    public static final int REQUEST_TAKE_PHOTO = 2457;
    public static final int REQUEST_IMPORT_PHOTO = 2456;
    private static final int REQUEST_IMPORT_VIDEO = 2455;
    OnPhotoImport onPhotoImport;
    private File photoFile;
    private OnPhotoTaken onPhotoTaken;
    private Context context;
    private OnVideoImport onVideoImport;

    private void takePhoto(Context context, OnPhotoTaken onPhotoTaken, Fragment fragment, AppCompatActivity appCompatActivity) {
        this.context = context;
        this.onPhotoTaken = onPhotoTaken;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(context.getPackageManager()) != null) {
            try {
                this.photoFile = this.createImageFile();
            }
            catch (IOException e) {
                onPhotoTaken.onPhotoError(e);
            }
            if (this.photoFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.photoFile));
                if (fragment != null) {
                    fragment.startActivityForResult(takePictureIntent, 2457);
                } else if (appCompatActivity != null) {
                    appCompatActivity.startActivityForResult(takePictureIntent, 2457);
                }
            }
        } else {
            onPhotoTaken.onPhotoError(new IllegalStateException("Not camera app installed"));
        }
    }

    public void takePhoto(AppCompatActivity context, OnPhotoTaken onPhotoTaken) {
        this.takePhoto((Context)context, onPhotoTaken, null, context);
    }

    public void takePhoto(Fragment context, OnPhotoTaken onPhotoTaken) {
        this.takePhoto(context.getContext(), onPhotoTaken, context, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importPhoto(Context context, @StringRes int message, OnPhotoImport callback, boolean allowMultiple, Fragment fragment, AppCompatActivity activity) {
        this.context = context;
        this.onPhotoImport = callback;
        if (callback == null) {
            throw new NullPointerException("OnMultiplePhotoImport must not be null");
        }
        if (allowMultiple) {
            if (Build.VERSION.SDK_INT < 18) throw new IllegalArgumentException("Multiple import require minimum API 18");
            Intent intent = new Intent();
            intent.setType("image/*");
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
            intent.setAction("android.intent.action.GET_CONTENT");
            if (fragment != null) {
                fragment.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)context.getString(message)), 2456);
                return;
            } else {
                if (activity == null) return;
                activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)context.getString(message)), 2456);
            }
            return;
        } else {
            Intent i = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            if (fragment != null) {
                fragment.startActivityForResult(i, 2456);
                return;
            } else {
                if (activity == null) return;
                activity.startActivityForResult(i, 2456);
            }
        }
    }

    public void importPhoto(AppCompatActivity context, @StringRes int message, OnPhotoImport callback, boolean allowMultiple) {
        this.importPhoto((Context)context, message, callback, allowMultiple, null, context);
    }

    public void importPhoto(Fragment context, @StringRes int message, OnPhotoImport callback, boolean allowMultiple) {
        this.importPhoto(context.getContext(), message, callback, allowMultiple, context, null);
    }

    public void importVideo(Fragment context, @StringRes int message, OnPhotoImport callback) {
        this.importVideo(context.getContext(), message, callback, context, null);
    }

    public void importVideo(AppCompatActivity context, @StringRes int message, OnPhotoImport callback) {
        this.importVideo((Context)context, message, callback, null, context);
    }

    private void importVideo(Context context, @StringRes int message, OnPhotoImport callback, Fragment fragment, AppCompatActivity appCompatActivity) {
        this.context = context;
        this.onPhotoImport = callback;
        if (callback == null) {
            throw new NullPointerException("OnPhotoImport must not be null");
        }
        Intent intent = new Intent();
        intent.setType("video/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        if (fragment != null) {
            fragment.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)context.getString(message)), 2455);
        } else if (appCompatActivity != null) {
            appCompatActivity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)context.getString(message)), 2455);
        }
    }

    @TargetApi(value=16)
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 2457) {
            if (resultCode == -1) {
                this.onPhotoTaken.onPhotoSuccess(this.fullBitmap(), this.photoFile);
            } else {
                this.onPhotoTaken.onPhotoCancelled();
            }
        } else if (requestCode == 2456 && resultCode == -1 && null != data) {
            Uri selectedFile = data.getData();
            if (selectedFile != null) {
                CameraImportTask task = new CameraImportTask(this.context, new Uri[]{selectedFile}, this.onPhotoImport);
                task.execute(new Void[0]);
            } else {
                ClipData clipData = data.getClipData();
                if (clipData != null) {
                    Uri[] uris = new Uri[clipData.getItemCount()];
                    for (int i = 0; i < clipData.getItemCount(); ++i) {
                        uris[i] = clipData.getItemAt(i).getUri();
                    }
                    CameraImportTask task = new CameraImportTask(this.context, uris, this.onPhotoImport);
                    task.execute(new Void[0]);
                } else {
                    this.onPhotoImport.onErrorImport(new RuntimeException("Photos not loaded"));
                }
            }
        } else if (requestCode == 2455 && resultCode == -1) {
            Uri selectedFile = data.getData();
            File file = new File(CameraImportTask.getRealPathFromURI(this.context, selectedFile));
            this.onVideoImport.onVideoImport(file);
            this.onVideoImport.onSuccessImport();
        }
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        return File.createTempFile(imageFileName, ".jpg", storageDir);
    }

    private Bitmap fullBitmap() {
        try {
            BitmapFactory.Options bmOptions = new BitmapFactory.Options();
            bmOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)this.photoFile.getAbsolutePath(), (BitmapFactory.Options)bmOptions);
            int photoW = bmOptions.outWidth;
            int photoH = bmOptions.outHeight;
            int scaleFactor = Math.min(photoW / 300, photoH / 300);
            bmOptions.inJustDecodeBounds = false;
            bmOptions.inSampleSize = scaleFactor;
            return BitmapFactory.decodeFile((String)this.photoFile.getAbsolutePath(), (BitmapFactory.Options)bmOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

