/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.validators;

import android.support.design.widget.TextInputLayout;
import android.widget.EditText;
import io.dflabs.lib.validators.FormValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EditTextValidator
extends FormValidator.Validator {
    private final EditText editText;
    private final int errorMessage;
    private final Pattern pattern;
    private final int minCharacters;
    private final int maxCharacters;

    public EditTextValidator(EditText editText, String regex, int errorMessage) {
        this.editText = editText;
        this.errorMessage = errorMessage;
        this.minCharacters = -1;
        this.maxCharacters = -1;
        this.pattern = Pattern.compile(regex);
    }

    public EditTextValidator(EditText editText, int minCharacters, int maxCharacters, int errorMessage) {
        this.editText = editText;
        this.errorMessage = errorMessage;
        this.minCharacters = minCharacters;
        this.maxCharacters = maxCharacters;
        if (minCharacters < 0) {
            throw new IllegalArgumentException("[EditTextValidator] Minimum number of characters is 0");
        }
        this.pattern = null;
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.minCharacters != -1) {
            boolean bl = valid = this.editText.getText().toString().trim().length() >= this.minCharacters;
        }
        if (this.maxCharacters != -1) {
            valid &= this.maxCharacters >= this.editText.getText().toString().trim().length();
        }
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(this.editText.getText().toString().trim());
            return valid & matcher.matches();
        }
        return valid;
    }

    @Override
    public void showError() {
        this.error(this.errorMessage);
    }

    private void error(Integer message) {
        try {
            TextInputLayout textInputLayout = (TextInputLayout)this.editText.getParent();
            textInputLayout.setErrorEnabled(true);
            textInputLayout.setError(message != null ? this.context.getString(message.intValue()) : null);
        }
        catch (ClassCastException ignored) {
            this.editText.setError(message != null ? this.context.getString(message.intValue()) : null);
        }
    }

    @Override
    void stopError() {
        this.error(null);
    }
}

