/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.validators;

import android.widget.CheckBox;
import io.dflabs.lib.validators.FormValidator;

public class CheckBoxGroupValidator
extends FormValidator.Validator {
    private final CheckBox checkBox;
    private final FormValidator.Validator[] validators;
    private final boolean showAllErrors;

    public CheckBoxGroupValidator(CheckBox checkBox, FormValidator.Validator[] validators, boolean showAllErrors) {
        this.checkBox = checkBox;
        this.validators = validators;
        this.showAllErrors = showAllErrors;
    }

    @Override
    boolean isValid() {
        boolean valid = true;
        if (this.checkBox.isChecked()) {
            for (FormValidator.Validator validator : this.validators) {
                validator.setContext(this.context);
                if (validator.isValid()) continue;
                valid = false;
            }
        }
        return valid;
    }

    @Override
    void showError() {
        if (this.showAllErrors) {
            for (FormValidator.Validator validator : this.validators) {
                if (validator.isValid()) continue;
                validator.showError();
            }
        } else {
            for (FormValidator.Validator validator : this.validators) {
                if (validator.isValid()) continue;
                validator.showError();
                break;
            }
        }
    }

    @Override
    void stopError() {
        for (FormValidator.Validator validator : this.validators) {
            if (!validator.isValid()) continue;
            validator.stopError();
        }
    }
}

