/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.mvp;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import io.dflabs.lib.adapters.RecyclerListAdapter;
import io.dflabs.lib.interfaces.OnLoadMoreItems;

public class LoadMoreItems
extends RecyclerView.OnScrollListener {
    private LinearLayoutManager mLinearLayoutManager;
    private OnLoadMoreItems onLoadMoreItems;
    private RecyclerListAdapter mAdapter;
    private boolean loading = true;
    private int previousTotal = 0;
    private int currentPage = 1;
    private int adapterType = 0;
    private int type = 0;

    public LoadMoreItems(OnLoadMoreItems onLoadMoreItems) {
        this.onLoadMoreItems = onLoadMoreItems;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        if (this.type == 0) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                this.type = 1;
                this.mLinearLayoutManager = (LinearLayoutManager)layoutManager;
            } else {
                throw new RuntimeException("LayoutManager must extends LinearLayout");
            }
        }
        int visibleItemCount = recyclerView.getChildCount();
        int totalItemCount = this.mLinearLayoutManager.getItemCount();
        int firstVisibleItem = this.mLinearLayoutManager.findFirstVisibleItemPosition();
        if (this.loading && totalItemCount > this.previousTotal + 1) {
            this.loading = false;
            this.previousTotal = totalItemCount;
        }
        int visibleThreshold = 1;
        if (!this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + visibleThreshold) {
            ++this.currentPage;
            if (this.adapterType == 0) {
                RecyclerView.Adapter adapter = recyclerView.getAdapter();
                if (adapter instanceof RecyclerListAdapter) {
                    this.adapterType = 1;
                    this.mAdapter = (RecyclerListAdapter)adapter;
                } else {
                    throw new RuntimeException("Adapter must extends RecyclerListAdapter");
                }
            }
            this.mAdapter.startEndlessLoading();
            this.onLoadMoreItems.onLoadMoreItems(this.currentPage);
            this.loading = true;
        }
    }
}

